/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PacketHandler;

public class GenericHandler<T extends Packet>
implements PacketHandler<T> {
    private Constructor<T> constructor;
    private boolean typeFound;
    private int type;

    public boolean isTypeFound() {
        return this.typeFound;
    }

    public int getType() {
        return this.type;
    }

    public GenericHandler(Class<T> clazz) {
        try {
            this.constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Packet class cannot be handled by GenericHandler", ex);
        }
        try {
            Field typeField = clazz.getField("TYPE");
            this.type = (Integer)typeField.get(null);
            this.typeFound = true;
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            this.typeFound = false;
        }
    }

    @Override
    public T handle(ByteBuffer buf) {
        try {
            Packet ret = (Packet)this.constructor.newInstance(new Object[0]);
            ret.parse(buf);
            return (T)ret;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException("Unable to instantiate empty packet", ex);
        }
    }
}

