/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt64Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.Version;
import org.eclipse.smarthome.binding.lifx.internal.fields.VersionField;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;

public class StateHostFirmwareResponse
extends Packet {
    public static final int TYPE = 15;
    public static final Field<Long> FIELD_BUILD = new UInt64Field().little();
    public static final Field<Long> FIELD_RESERVED = new UInt64Field().little();
    public static final Field<Version> FIELD_VERSION = new VersionField().little();
    private long build;
    private long reserved;
    private Version version;

    public long getBuild() {
        return this.build;
    }

    public void setBuild(long build) {
        this.build = build;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public StateHostFirmwareResponse() {
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    @Override
    public int packetType() {
        return 15;
    }

    @Override
    protected int packetLength() {
        return 20;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.build = FIELD_BUILD.value(bytes);
        this.reserved = FIELD_RESERVED.value(bytes);
        this.version = FIELD_VERSION.value(bytes);
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_BUILD.bytes(this.build)).put(FIELD_RESERVED.bytes(this.reserved)).put(FIELD_VERSION.bytes(this.version));
    }

    @Override
    public int[] expectedResponses() {
        return new int[0];
    }
}

