/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public final class LifxNetworkUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifxNetworkUtil.class);
    private static final AtomicInteger BROADCAST_PORT_COUNTER = new AtomicInteger(1);
    private static final long UPDATE_INTERVAL_MILLIS = Duration.ofSeconds(15L).toMillis();
    private static final int PORT_MAX = 65535;
    private static List<InetSocketAddress> broadcastAddresses = new ArrayList<InetSocketAddress>();
    private static List<InetAddress> interfaceAddresses = new ArrayList<InetAddress>();
    private static int bufferSize;
    private static long lastUpdateMillis;

    private LifxNetworkUtil() {
    }

    private static void updateNetworkInformation() {
        LOGGER.debug("Updating network information");
        ArrayList<InetSocketAddress> newBroadcastAddresses = new ArrayList<InetSocketAddress>();
        ArrayList<InetAddress> newInterfaceAddresses = new ArrayList<InetAddress>();
        int newBufferSize = 0;
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            LOGGER.debug("Exception while getting network interfaces: '{}'", (Object)e.getMessage());
        }
        if (networkInterfaces != null) {
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface iface = networkInterfaces.nextElement();
                try {
                    if (!iface.isUp() || iface.isLoopback()) continue;
                    for (InterfaceAddress ifaceAddr : iface.getInterfaceAddresses()) {
                        if (!(ifaceAddr.getAddress() instanceof Inet4Address)) continue;
                        newInterfaceAddresses.add(ifaceAddr.getAddress());
                        newBufferSize = Math.max(newBufferSize, iface.getMTU());
                        if (ifaceAddr.getBroadcast() == null) continue;
                        newBroadcastAddresses.add(new InetSocketAddress(ifaceAddr.getBroadcast(), 56700));
                    }
                }
                catch (SocketException e) {
                    LOGGER.debug("Exception while getting information for network interface '{}': '{}'", (Object)iface.getName(), (Object)e.getMessage());
                }
            }
            broadcastAddresses = newBroadcastAddresses;
            interfaceAddresses = newInterfaceAddresses;
            bufferSize = newBufferSize;
        }
        lastUpdateMillis = System.currentTimeMillis();
    }

    private static void updateOutdatedNetworkInformation() {
        boolean updateIntervalElapsed;
        boolean bl = updateIntervalElapsed = System.currentTimeMillis() - lastUpdateMillis > UPDATE_INTERVAL_MILLIS;
        if (updateIntervalElapsed) {
            LifxNetworkUtil.updateNetworkInformation();
        }
    }

    public static List<InetSocketAddress> getBroadcastAddresses() {
        LifxNetworkUtil.updateOutdatedNetworkInformation();
        return broadcastAddresses;
    }

    public static List<InetAddress> getInterfaceAddresses() {
        LifxNetworkUtil.updateOutdatedNetworkInformation();
        return interfaceAddresses;
    }

    public static int getBufferSize() {
        LifxNetworkUtil.updateOutdatedNetworkInformation();
        return bufferSize;
    }

    public static boolean isLocalAddress(InetAddress address) {
        return LifxNetworkUtil.getInterfaceAddresses().contains(address);
    }

    public static boolean isRemoteAddress(InetAddress address) {
        return !LifxNetworkUtil.isLocalAddress(address);
    }

    public static int getNewBroadcastPort() {
        int offset = BROADCAST_PORT_COUNTER.getAndUpdate(value -> (value + 1) % Integer.MAX_VALUE);
        return 56700 + offset % 8835;
    }
}

