/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.internal.normalization.Normalizer;
import org.eclipse.smarthome.config.core.internal.normalization.NormalizerFactory;

public class ConfigUtil {
    private static boolean isOSGiConfigParameter(String name) {
        return name.equals("objectClass") || name.equals("component.name") || name.equals("component.id");
    }

    public static Map<String, Object> normalizeTypes(Map<String, Object> configuration) {
        HashMap<String, Object> convertedConfiguration = new HashMap<String, Object>(configuration.size());
        for (Map.Entry<String, Object> parameter : configuration.entrySet()) {
            String name = parameter.getKey();
            Object value = parameter.getValue();
            if (ConfigUtil.isOSGiConfigParameter(name)) continue;
            convertedConfiguration.put(name, ConfigUtil.normalizeType(value));
        }
        return convertedConfiguration;
    }

    public static Object normalizeType(Object value) {
        return ConfigUtil.normalizeType(value, null);
    }

    public static Object normalizeType(Object value, ConfigDescriptionParameter configDescriptionParameter) {
        if (configDescriptionParameter != null) {
            Normalizer normalizer = NormalizerFactory.getNormalizer(configDescriptionParameter);
            return normalizer.normalize(value);
        }
        if (value == null || value instanceof Boolean || value instanceof String || value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString());
        }
        if (value instanceof Collection) {
            return ConfigUtil.normalizeCollection((Collection)value);
        }
        throw new IllegalArgumentException("Invalid type '{" + value.getClass().getCanonicalName() + "}' of configuration value!");
    }

    private static Collection<Object> normalizeCollection(Collection<?> collection) throws IllegalArgumentException {
        if (collection.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> lst = new ArrayList<Object>(collection.size());
        for (Object it : collection) {
            Object normalized = ConfigUtil.normalizeType(it);
            lst.add(normalized);
            if (normalized.getClass() == lst.get(0).getClass()) continue;
            throw new IllegalArgumentException("Invalid configuration property. Heterogeneous collection value!");
        }
        return lst;
    }

    public static Map<String, Object> normalizeTypes(Map<String, Object> configuration, List<ConfigDescription> configDescriptions) {
        if (configDescriptions == null || configDescriptions.isEmpty()) {
            throw new IllegalArgumentException("Config description must not be null.");
        }
        if (configuration == null) {
            return null;
        }
        HashMap<String, Object> convertedConfiguration = new HashMap<String, Object>();
        HashMap<String, ConfigDescriptionParameter> configParams = new HashMap<String, ConfigDescriptionParameter>();
        int i = configDescriptions.size() - 1;
        while (i >= 0) {
            configParams.putAll(configDescriptions.get(i).toParametersMap());
            --i;
        }
        for (Map.Entry<String, Object> parameter : configuration.entrySet()) {
            String name = parameter.getKey();
            Object value = parameter.getValue();
            if (ConfigUtil.isOSGiConfigParameter(name)) continue;
            ConfigDescriptionParameter configDescriptionParameter = (ConfigDescriptionParameter)configParams.get(name);
            convertedConfiguration.put(name, ConfigUtil.normalizeType(value, configDescriptionParameter));
        }
        return convertedConfiguration;
    }
}

