/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.weatherunderground.internal.json;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public class WeatherUndergroundJsonUtils {
    public static Object getValue(String channelId, Object data) throws Exception {
        String[] fields = StringUtils.split((String)channelId, (String)"#");
        return WeatherUndergroundJsonUtils.getValue(data, fields, 0);
    }

    private static Object getValue(Object data, String[] fields, int index) throws Exception {
        if (data == null) {
            return null;
        }
        String fieldName = fields[index];
        Method method = data.getClass().getMethod(WeatherUndergroundJsonUtils.toGetterString(fieldName), null);
        Object result = method.invoke(data, null);
        if (index + 1 < fields.length) {
            result = WeatherUndergroundJsonUtils.getValue(result, fields, index + 1);
        }
        return result;
    }

    private static String toGetterString(String str) {
        StringBuilder sb = new StringBuilder();
        sb.append("get");
        sb.append(Character.toTitleCase(str.charAt(0)));
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static Calendar convertToCalendar(String value) {
        Calendar result = null;
        if (WeatherUndergroundJsonUtils.isValid(value)) {
            try {
                result = Calendar.getInstance();
                result.setTimeInMillis(Long.valueOf(value) * 1000L);
            }
            catch (NumberFormatException numberFormatException) {
                LoggerFactory.getLogger(WeatherUndergroundJsonUtils.class).debug("Cannot convert {} to Calendar", (Object)value);
                result = null;
            }
        }
        return result;
    }

    public static Integer convertToInteger(String value) {
        Integer result = null;
        if (WeatherUndergroundJsonUtils.isValid(value)) {
            try {
                result = Integer.valueOf(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                LoggerFactory.getLogger(WeatherUndergroundJsonUtils.class).debug("Cannot convert {} to Integer", (Object)value);
                result = null;
            }
        }
        return result;
    }

    public static BigDecimal convertToBigDecimal(String value) {
        BigDecimal result = null;
        if (WeatherUndergroundJsonUtils.isValid(value)) {
            result = new BigDecimal(value.trim());
        }
        return result;
    }

    private static boolean isValid(String value) {
        return value != null && !value.isEmpty() && !value.equalsIgnoreCase("N/A") && !value.equalsIgnoreCase("NA") && !value.equals("-") && !value.equals("--");
    }

    public static URL getValidUrl(String url) {
        URL validUrl = null;
        if (StringUtils.isNotBlank((String)url)) {
            try {
                validUrl = new URL(url);
            }
            catch (MalformedURLException malformedURLException) {
                validUrl = null;
            }
        }
        return validUrl;
    }
}

