/**
 * Copyright (c) 2014,2017 Contributors to the Eclipse Foundation
 * 
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.model.script.internal.engine;

import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.smarthome.model.script.ScriptServiceUtil;
import org.eclipse.smarthome.model.script.engine.IActionServiceProvider;
import org.eclipse.smarthome.model.script.engine.action.ActionService;

@Singleton
@SuppressWarnings("all")
public class ServiceTrackerActionServiceProvider implements IActionServiceProvider {
  private final ScriptServiceUtil scriptServiceUtil;
  
  public ServiceTrackerActionServiceProvider(final ScriptServiceUtil scriptServiceUtil) {
    this.scriptServiceUtil = scriptServiceUtil;
  }
  
  @Override
  public List<ActionService> get() {
    return this.scriptServiceUtil.getActionServiceInstances();
  }
}
