/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.media.handler;

import java.util.Map;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.core.audio.AudioException;
import org.eclipse.smarthome.core.audio.AudioManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayActionHandler
extends BaseModuleHandler<Action>
implements ActionHandler {
    public static final String TYPE_ID = "media.PlayAction";
    public static final String PARAM_SOUND = "sound";
    public static final String PARAM_SINK = "sink";
    private final Logger logger = LoggerFactory.getLogger(PlayActionHandler.class);
    private final AudioManager audioManager;

    public PlayActionHandler(Action module, AudioManager audioManager) {
        super((Module)module);
        this.audioManager = audioManager;
    }

    public Map<String, Object> execute(Map<String, Object> context) {
        String sound = ((Action)this.module).getConfiguration().get(PARAM_SOUND).toString();
        String sink = (String)((Action)this.module).getConfiguration().get(PARAM_SINK);
        try {
            this.audioManager.playFile(sound, sink);
        }
        catch (AudioException e) {
            this.logger.error("Error playing sound '{}': {}", (Object)sound, (Object)e.getMessage());
        }
        return null;
    }
}

