/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCharacteristic;

public class BluetoothDescriptor {
    protected final BluetoothCharacteristic characteristic;
    protected final UUID uuid;
    protected byte[] value;

    public BluetoothDescriptor(BluetoothCharacteristic characteristic, UUID uuid) {
        this.characteristic = characteristic;
        this.uuid = uuid;
    }

    BluetoothCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    public int getPermissions() {
        return 0;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public GattDescriptor getDescriptor() {
        return GattDescriptor.getDescriptor(this.uuid);
    }

    public static enum GattDescriptor {
        CHARACTERISTIC_EXTENDED_PROPERTIES(10496L),
        CHARACTERISTIC_USER_DESCRIPTION(10497L),
        CLIENT_CHARACTERISTIC_CONFIGURATION(10498L),
        SERVER_CHARACTERISTIC_CONFIGURATION(10499L),
        CHARACTERISTIC_PRESENTATION_FORMAT(10500L),
        CHARACTERISTIC_AGGREGATE_FORMAT(10501L),
        VALID_RANGE(10502L),
        EXTERNAL_REPORT_REFERENCE(10503L),
        REPORT_REFERENCE(10504L),
        NUMBER_OF_DIGITALS(10505L),
        TRIGGER_SETTING(10506L);

        private static Map<UUID, GattDescriptor> uuidToServiceMapping;
        private final UUID uuid;

        private GattDescriptor(long key) {
            this.uuid = new UUID(key << 32 | 0x1000L, -9223371485494954757L);
        }

        private static void initMapping() {
            uuidToServiceMapping = new HashMap<UUID, GattDescriptor>();
            GattDescriptor[] gattDescriptorArray = GattDescriptor.values();
            int n = gattDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                GattDescriptor s = gattDescriptorArray[n2];
                uuidToServiceMapping.put(s.uuid, s);
                ++n2;
            }
        }

        public static GattDescriptor getDescriptor(UUID uuid) {
            if (uuidToServiceMapping == null) {
                GattDescriptor.initMapping();
            }
            return uuidToServiceMapping.get(uuid);
        }

        public UUID getUUID() {
            return this.uuid;
        }
    }
}

