/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.handler;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.smarthome.binding.homematic.handler.HomematicThingHandler;
import org.eclipse.smarthome.binding.homematic.handler.SimplePortPool;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomematicGateway;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomematicGatewayAdapter;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomematicGatewayFactory;
import org.eclipse.smarthome.binding.homematic.internal.discovery.HomematicDeviceDiscoveryService;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointConfig;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmGatewayInfo;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicTypeGenerator;
import org.eclipse.smarthome.binding.homematic.internal.type.UidUtils;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomematicBridgeHandler
extends BaseBridgeHandler
implements HomematicGatewayAdapter {
    private final Logger logger = LoggerFactory.getLogger(HomematicBridgeHandler.class);
    private static final long REINITIALIZE_DELAY_SECONDS = 10L;
    private static final int DUTY_CYCLE_RATIO_LIMIT = 99;
    private static SimplePortPool portPool = new SimplePortPool();
    private final Object dutyCycleRatioUpdateLock = new Object();
    private final Object initDisposeLock = new Object();
    private Future<?> initializeFuture;
    private boolean isDisposed;
    private HomematicConfig config;
    private HomematicGateway gateway;
    private final HomematicTypeGenerator typeGenerator;
    private final HttpClient httpClient;
    private HomematicDeviceDiscoveryService discoveryService;
    private ServiceRegistration<?> discoveryServiceRegistration;
    private final String ipv4Address;
    private boolean isInDutyCycle = false;
    private int dutyCycleRatio = 0;

    public HomematicBridgeHandler(@NonNull Bridge bridge, HomematicTypeGenerator typeGenerator, String ipv4Address, HttpClient httpClient) {
        super(bridge);
        this.typeGenerator = typeGenerator;
        this.ipv4Address = ipv4Address;
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.initDisposeLock;
        synchronized (object) {
            this.isDisposed = false;
            this.initializeFuture = this.scheduler.submit(this::initializeInternal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeInternal() {
        Object object = this.initDisposeLock;
        synchronized (object) {
            this.config = this.createHomematicConfig();
            this.registerDeviceDiscoveryService();
            try {
                String id = this.getThing().getUID().getId();
                this.gateway = HomematicGatewayFactory.createGateway(id, this.config, this, this.httpClient);
                this.configureThingProperties();
                this.gateway.initialize();
                this.discoveryService.startScan(null);
                this.discoveryService.waitForScanFinishing();
                this.updateStatus(ThingStatus.ONLINE);
                if (!this.config.getGatewayInfo().isHomegear()) {
                    try {
                        this.gateway.loadRssiValues();
                    }
                    catch (IOException ex) {
                        this.logger.warn("Unable to load RSSI values from bridge '{}'", (Object)this.getThing().getUID().getId());
                        this.logger.error("{}", (Object)ex.getMessage(), (Object)ex);
                    }
                }
                this.gateway.startWatchdogs();
            }
            catch (IOException ex) {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, ex.getMessage());
                this.logger.debug("Homematic bridge was set to OFFLINE-COMMUNICATION_ERROR due to the following exception: {}", (Object)ex.getMessage(), (Object)ex);
                this.disposeInternal();
                this.scheduleReinitialize();
            }
        }
    }

    private void configureThingProperties() {
        HmGatewayInfo info = this.config.getGatewayInfo();
        Map properties = this.getThing().getProperties();
        if (!properties.containsKey("firmwareVersion")) {
            this.getThing().setProperty("firmwareVersion", info.getFirmware());
        }
        if (!properties.containsKey("serialNumber")) {
            this.getThing().setProperty("serialNumber", info.getAddress());
        }
        if (!properties.containsKey("modelId")) {
            this.getThing().setProperty("modelId", info.getType());
        }
    }

    private void scheduleReinitialize() {
        if (!this.isDisposed) {
            this.initializeFuture = this.scheduler.schedule(this::initializeInternal, 10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.initDisposeLock;
        synchronized (object) {
            super.dispose();
            if (this.initializeFuture != null) {
                this.initializeFuture.cancel(true);
            }
            this.disposeInternal();
            this.isDisposed = true;
        }
    }

    private void disposeInternal() {
        this.logger.debug("Disposing bridge '{}'", (Object)this.getThing().getUID().getId());
        if (this.discoveryService != null) {
            this.discoveryService.stopScan();
            this.unregisterDeviceDiscoveryService();
        }
        if (this.gateway != null) {
            this.gateway.dispose();
        }
        if (this.config != null) {
            portPool.release(this.config.getXmlCallbackPort());
            portPool.release(this.config.getBinCallbackPort());
        }
    }

    private void registerDeviceDiscoveryService() {
        if (this.bundleContext != null) {
            this.logger.trace("Registering HomematicDeviceDiscoveryService for bridge '{}'", (Object)this.getThing().getUID().getId());
            this.discoveryService = new HomematicDeviceDiscoveryService(this);
            this.discoveryServiceRegistration = this.bundleContext.registerService(DiscoveryService.class.getName(), (Object)this.discoveryService, new Hashtable());
            this.discoveryService.activate();
        }
    }

    private void unregisterDeviceDiscoveryService() {
        if (this.discoveryServiceRegistration != null && this.bundleContext != null) {
            HomematicDeviceDiscoveryService service = (HomematicDeviceDiscoveryService)((Object)this.bundleContext.getService(this.discoveryServiceRegistration.getReference()));
            if (service != null) {
                service.deactivate();
            }
            this.discoveryServiceRegistration.unregister();
            this.discoveryServiceRegistration = null;
            this.discoveryService = null;
        }
    }

    public void setOfflineStatus() {
        for (Thing hmThing : this.getThing().getThings()) {
            try {
                this.gateway.getDevice(UidUtils.getHomematicAddress(hmThing));
            }
            catch (HomematicClientException homematicClientException) {
                if (hmThing.getHandler() == null) continue;
                ((HomematicThingHandler)hmThing.getHandler()).handleRemoval();
            }
        }
    }

    private HomematicConfig createHomematicConfig() {
        HomematicConfig homematicConfig = (HomematicConfig)this.getThing().getConfiguration().as(HomematicConfig.class);
        if (homematicConfig.getCallbackHost() == null) {
            homematicConfig.setCallbackHost(this.ipv4Address);
        }
        if (homematicConfig.getBindAddress() == null) {
            homematicConfig.setBindAddress(homematicConfig.getCallbackHost());
        }
        if (homematicConfig.getXmlCallbackPort() == 0) {
            homematicConfig.setXmlCallbackPort(portPool.getNextPort());
        } else {
            portPool.setInUse(homematicConfig.getXmlCallbackPort());
        }
        if (homematicConfig.getBinCallbackPort() == 0) {
            homematicConfig.setBinCallbackPort(portPool.getNextPort());
        } else {
            portPool.setInUse(homematicConfig.getBinCallbackPort());
        }
        this.logger.debug("{}", (Object)homematicConfig);
        return homematicConfig;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (RefreshType.REFRESH == command) {
            this.logger.debug("Refreshing bridge '{}'", (Object)this.getThing().getUID().getId());
            this.reloadAllDeviceValues();
        }
    }

    public HomematicTypeGenerator getTypeGenerator() {
        return this.typeGenerator;
    }

    public HomematicGateway getGateway() {
        return this.gateway;
    }

    private void updateThing(HmDevice device) {
        HomematicThingHandler thingHandler;
        Thing hmThing = this.getThingByUID(UidUtils.generateThingUID(device, this.getThing()));
        if (hmThing != null && (thingHandler = (HomematicThingHandler)hmThing.getHandler()) != null) {
            thingHandler.thingUpdated(hmThing);
            for (Channel channel : hmThing.getChannels()) {
                thingHandler.handleRefresh(channel.getUID());
            }
        }
    }

    @Override
    public void onStateUpdated(HmDatapoint dp) {
        HomematicThingHandler thingHandler;
        ThingStatus status;
        Thing hmThing = this.getThingByUID(UidUtils.generateThingUID(dp.getChannel().getDevice(), this.getThing()));
        if (hmThing != null && ((status = hmThing.getStatus()) == ThingStatus.ONLINE || status == ThingStatus.OFFLINE) && (thingHandler = (HomematicThingHandler)hmThing.getHandler()) != null) {
            thingHandler.updateDatapointState(dp);
        }
    }

    @Override
    public HmDatapointConfig getDatapointConfig(HmDatapoint dp) {
        HomematicThingHandler thingHandler;
        Thing hmThing = this.getThingByUID(UidUtils.generateThingUID(dp.getChannel().getDevice(), this.getThing()));
        if (hmThing != null && (thingHandler = (HomematicThingHandler)hmThing.getHandler()) != null) {
            return thingHandler.getChannelConfig(dp);
        }
        return new HmDatapointConfig();
    }

    @Override
    public void onNewDevice(HmDevice device) {
        this.onDeviceLoaded(device);
        this.updateThing(device);
    }

    @Override
    public void onDeviceDeleted(HmDevice device) {
        this.discoveryService.deviceRemoved(device);
        this.updateThing(device);
        Thing hmThing = this.getThingByUID(UidUtils.generateThingUID(device, this.getThing()));
        if (hmThing != null && hmThing.getHandler() != null) {
            ((HomematicThingHandler)hmThing.getHandler()).deviceRemoved();
        }
    }

    @Override
    public void onConnectionLost() {
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "Connection lost");
    }

    @Override
    public void onConnectionResumed() {
        this.updateStatus(ThingStatus.ONLINE);
        this.reloadAllDeviceValues();
    }

    @Override
    public void onDeviceLoaded(HmDevice device) {
        HomematicThingHandler thingHandler;
        Thing hmThing;
        this.typeGenerator.generate(device);
        if (this.discoveryService != null) {
            this.discoveryService.deviceDiscovered(device);
        }
        if ((hmThing = this.getThingByUID(UidUtils.generateThingUID(device, this.getThing()))) != null && (thingHandler = (HomematicThingHandler)hmThing.getHandler()) != null) {
            thingHandler.deviceLoaded(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDutyCycleRatioUpdate(int dutyCycleRatio) {
        Object object = this.dutyCycleRatioUpdateLock;
        synchronized (object) {
            this.dutyCycleRatio = dutyCycleRatio;
            Channel dutyCycleRatioChannel = this.thing.getChannel("DUTY_CYCLE_RATIO");
            if (dutyCycleRatioChannel != null) {
                this.updateState(dutyCycleRatioChannel.getUID(), (State)new DecimalType((long)dutyCycleRatio));
            }
            if (!this.isInDutyCycle && dutyCycleRatio >= 99) {
                this.logger.info("Duty cycle threshold exceeded by homematic bridge {}, it will go OFFLINE.", (Object)this.thing.getUID());
                this.isInDutyCycle = true;
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.DUTY_CYCLE);
            } else if (this.isInDutyCycle && dutyCycleRatio < 99) {
                this.logger.info("Homematic bridge {} fell below duty cycle threshold and will come ONLINE again.", (Object)this.thing.getUID());
                this.isInDutyCycle = false;
                this.updateStatus(ThingStatus.ONLINE);
            }
        }
    }

    public int getDutyCycleRatio() {
        return this.dutyCycleRatio;
    }

    @Override
    public void reloadDeviceValues(HmDevice device) {
        this.updateThing(device);
        if (device.isGatewayExtras()) {
            this.typeGenerator.generate(device);
        }
    }

    @Override
    public void reloadAllDeviceValues() {
        for (Thing hmThing : this.getThing().getThings()) {
            try {
                HmDevice device = this.gateway.getDevice(UidUtils.getHomematicAddress(hmThing));
                this.gateway.triggerDeviceValuesReload(device);
            }
            catch (HomematicClientException ex) {
                this.logger.warn("{}", (Object)ex.getMessage());
            }
        }
    }

    public void childHandlerDisposed(ThingHandler childHandler, Thing childThing) {
        if (((HomematicThingHandler)childHandler).isDeletionPending()) {
            this.deleteFromGateway(UidUtils.getHomematicAddress(childThing), false, true, false);
        }
    }

    public void updateDatapoint(HmDatapoint dp) throws IOException {
        this.getGateway().loadDatapointValue(dp);
    }

    public void deleteFromGateway(String address, boolean reset, boolean force, boolean defer) {
        this.scheduler.submit(() -> {
            this.logger.debug("Deleting the device '{}' from gateway '{}'", (Object)address, (Object)this.getBridge());
            this.getGateway().deleteDevice(address, reset, force, defer);
        });
    }
}

