/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcRequest;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.DeleteDevicesParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.EventParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.NewDevicesParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.RpcEventListener;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcResponseHandler<T> {
    private final Logger logger = LoggerFactory.getLogger(RpcResponseHandler.class);
    private RpcEventListener listener;

    public RpcResponseHandler(RpcEventListener listener) {
        this.listener = listener;
    }

    public T handleMethodCall(String methodName, Object[] responseData) throws IOException {
        if ("event".equals(methodName)) {
            return this.handleEvent(responseData);
        }
        if ("listDevices".equals(methodName) || "updateDevice".equals(methodName)) {
            return this.getEmptyArrayResult();
        }
        if ("deleteDevices".equals(methodName)) {
            return this.handleDeleteDevice(responseData);
        }
        if ("newDevices".equals(methodName)) {
            return this.handleNewDevice(responseData);
        }
        if ("system.listMethods".equals(methodName)) {
            RpcRequest<T> msg = this.createRpcRequest();
            msg.addArg(this.getListMethods());
            return msg.createMessage();
        }
        if ("system.multicall".equals(methodName)) {
            Object[] objectArray = (Object[])responseData[0];
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Map call = (Map)o;
                if (call != null) {
                    String method = ObjectUtils.toString(call.get("methodName"));
                    Object[] data = (Object[])call.get("params");
                    this.handleMethodCall(method, data);
                }
                ++n2;
            }
            return this.getEmptyEventListResult();
        }
        if ("setReadyConfig".equals(methodName)) {
            return this.getEmptyEventListResult();
        }
        this.logger.warn("Unknown method called by Homematic gateway: {}", (Object)methodName);
        return this.getEmptyEventListResult();
    }

    private List<String> getListMethods() {
        ArrayList<String> events = new ArrayList<String>();
        events.add("system.multicall");
        events.add("event");
        events.add("deleteDevices");
        events.add("newDevices");
        return events;
    }

    private T handleEvent(Object[] message) throws IOException {
        EventParser eventParser = new EventParser();
        HmDatapointInfo dpInfo = eventParser.parse(message);
        this.listener.eventReceived(dpInfo, eventParser.getValue());
        return this.getEmptyStringResult();
    }

    private T handleNewDevice(Object[] message) throws IOException {
        NewDevicesParser ndParser = new NewDevicesParser();
        List<String> adresses = ndParser.parse(message);
        this.listener.newDevices(adresses);
        return this.getEmptyArrayResult();
    }

    private T handleDeleteDevice(Object[] message) throws IOException {
        DeleteDevicesParser ddParser = new DeleteDevicesParser();
        List<String> adresses = ddParser.parse(message);
        this.listener.deleteDevices(adresses);
        return this.getEmptyArrayResult();
    }

    protected abstract T getEmptyStringResult();

    protected abstract T getEmptyArrayResult();

    protected abstract T getEmptyEventListResult();

    protected abstract RpcRequest<T> createRpcRequest();
}

