/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.misc.MiscUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButtonVirtualDatapointHandler
extends AbstractVirtualDatapointHandler {
    private final Logger logger = LoggerFactory.getLogger(ButtonVirtualDatapointHandler.class);

    @Override
    public String getName() {
        return "BUTTON";
    }

    @Override
    public void initialize(HmDevice device) {
        for (HmChannel channel : device.getChannels()) {
            if (!channel.hasPressDatapoint()) continue;
            HmDatapoint dp = this.addDatapoint(device, channel.getNumber(), this.getName(), HmValueType.STRING, null, false);
            dp.setTrigger(true);
            dp.setOptions(new String[]{"SHORT_PRESSED", "LONG_PRESSED", "DOUBLE_PRESSED"});
        }
    }

    @Override
    public boolean canHandleEvent(HmDatapoint dp) {
        return dp.isPressDatapoint();
    }

    @Override
    public void handleEvent(VirtualGateway gateway, HmDatapoint dp) {
        block18: {
            HmDatapoint vdp;
            block16: {
                String pressType;
                vdp = this.getVirtualDatapoint(dp.getChannel());
                if (!MiscUtils.isTrueValue(dp.getValue())) break block16;
                switch (pressType = StringUtils.substringAfter((String)dp.getName(), (String)"_")) {
                    case "SHORT": {
                        if (dp.getValue() == null || !dp.getValue().equals(dp.getPreviousValue())) {
                            vdp.setValue("SHORT_PRESSED");
                            break;
                        }
                        vdp.setValue("DOUBLE_PRESSED");
                        break;
                    }
                    case "LONG": {
                        vdp.setValue("LONG_PRESSED");
                        break;
                    }
                    case "LONG_RELEASE": 
                    case "CONT": {
                        vdp.setValue(null);
                        break;
                    }
                    default: {
                        vdp.setValue(null);
                        this.logger.warn("Unexpected vaule '{}' for PRESS virtual datapoint", (Object)pressType);
                        break;
                    }
                }
                break block18;
            }
            vdp.setValue(null);
        }
    }
}

