/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.DisplayOptionsParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointConfig;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmInterface;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;

public class DisplayOptionsVirtualDatapointHandler
extends AbstractVirtualDatapointHandler {
    @Override
    public String getName() {
        return "DISPLAY_OPTIONS";
    }

    @Override
    public void initialize(HmDevice device) {
        if (device.getType().startsWith("HM-RC-19") && device.getHmInterface() != HmInterface.CUXD) {
            this.addDatapoint(device, 18, this.getName(), HmValueType.STRING, null, false);
        }
    }

    @Override
    public boolean canHandleCommand(HmDatapoint dp, Object value) {
        return this.getName().equals(dp.getName());
    }

    @Override
    public void handleCommand(VirtualGateway gateway, HmDatapoint dp, HmDatapointConfig dpConfig, Object value) throws IOException, HomematicClientException {
        HmChannel channel = dp.getChannel();
        DisplayOptionsParser rcOptionsParser = new DisplayOptionsParser(channel);
        rcOptionsParser.parse(value);
        if (StringUtils.isNotBlank((String)rcOptionsParser.getText())) {
            this.sendDatapoint(gateway, channel, "TEXT", rcOptionsParser.getText());
        }
        this.sendDatapoint(gateway, channel, "BEEP", rcOptionsParser.getBeep());
        this.sendDatapoint(gateway, channel, "UNIT", rcOptionsParser.getUnit());
        this.sendDatapoint(gateway, channel, "BACKLIGHT", rcOptionsParser.getBacklight());
        for (String symbol : rcOptionsParser.getSymbols()) {
            this.sendDatapoint(gateway, channel, symbol, Boolean.TRUE);
        }
        this.sendDatapoint(gateway, channel, "SUBMIT", Boolean.TRUE);
        dp.setValue(value);
    }

    private void sendDatapoint(VirtualGateway gateway, HmChannel channel, String dpName, Object newValue) throws IOException, HomematicClientException {
        HmDatapointInfo dpInfo = HmDatapointInfo.createValuesInfo(channel, dpName);
        HmDatapoint dp = gateway.getDatapoint(dpInfo);
        gateway.sendDatapoint(dp, new HmDatapointConfig(), newValue, null);
    }
}

