/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.RssiVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;

public class SignalStrengthVirtualDatapointHandler
extends RssiVirtualDatapointHandler {
    private static final int RSSI_START = 40;
    private static final int RSSI_STEP = 25;
    private static final int RSSI_UNITS = 4;

    @Override
    public String getName() {
        return "SIGNAL_STRENGTH";
    }

    @Override
    public void initialize(HmDevice device) {
        if (this.isWirelessDevice(device)) {
            this.addDatapoint(device, 0, this.getName(), HmValueType.INTEGER, this.getRssiValue(device.getChannel(0)), true);
        }
    }

    @Override
    public void handleEvent(VirtualGateway gateway, HmDatapoint dp) {
        HmChannel channel = dp.getChannel();
        Integer value = this.getRssiValue(channel);
        if (value != null) {
            Integer strength = Math.max(Math.abs(value), 40);
            strength = strength > 140 ? 0 : 4 - (strength - 40) / 25;
            HmDatapoint vdpRssi = this.getVirtualDatapoint(channel);
            vdpRssi.setValue(strength);
        }
    }
}

