/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.converter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.binding.homematic.internal.converter.ConverterException;
import org.eclipse.smarthome.binding.homematic.internal.converter.TypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.DecimalTypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.OnOffTypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.OpenClosedTypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.PercentTypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.QuantityTypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.StringTypeConverter;

public class ConverterFactory {
    private static Map<String, TypeConverter<?>> converterCache = new HashMap();

    public static TypeConverter<?> createConverter(String itemType) throws ConverterException {
        Class converterClass;
        block26: {
            block25: {
                converterClass = null;
                if (!itemType.startsWith("Number:")) break block25;
                converterClass = QuantityTypeConverter.class;
                break block26;
            }
            switch (itemType) {
                case "Switch": {
                    converterClass = OnOffTypeConverter.class;
                    break;
                }
                case "Rollershutter": 
                case "Dimmer": {
                    converterClass = PercentTypeConverter.class;
                    break;
                }
                case "Contact": {
                    converterClass = OpenClosedTypeConverter.class;
                    break;
                }
                case "String": {
                    converterClass = StringTypeConverter.class;
                    break;
                }
                case "Number": {
                    converterClass = DecimalTypeConverter.class;
                }
            }
        }
        TypeConverter converter = null;
        if (converterClass != null && (converter = converterCache.get(converterClass.getName())) == null) {
            try {
                converter = (TypeConverter)converterClass.newInstance();
                converterCache.put(converterClass.getName(), converter);
            }
            catch (Exception exception) {}
        }
        if (converter == null) {
            throw new ConverterException("Can't find a converter for type '" + itemType + "'");
        }
        return converter;
    }
}

