/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.converter.type;

import org.eclipse.smarthome.binding.homematic.internal.converter.ConverterException;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.AbstractTypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Type;

public class StringTypeConverter
extends AbstractTypeConverter<StringType> {
    @Override
    protected boolean toBindingValidation(HmDatapoint dp, Class<? extends Type> typeClass) {
        return (dp.isStringType() || dp.isEnumType()) && typeClass.isAssignableFrom(StringType.class);
    }

    @Override
    protected Object toBinding(StringType type, HmDatapoint dp) throws ConverterException {
        if (dp.isStringType()) {
            return type.toString();
        }
        int idx = dp.getOptionIndex(type.toString());
        if (idx == -1) {
            throw new ConverterException(String.format("Option value '%s' not found in datapoint '%s'", type.toString(), new HmDatapointInfo(dp)));
        }
        return idx;
    }

    @Override
    protected boolean fromBindingValidation(HmDatapoint dp) {
        return dp.isStringType() || dp.isEnumType() && dp.getValue() instanceof Number;
    }

    @Override
    protected StringType fromBinding(HmDatapoint dp) throws ConverterException {
        if (dp.isStringType()) {
            return new StringType(String.valueOf(dp.getValue()));
        }
        String value = dp.getOptionValue();
        if (value == null) {
            throw new ConverterException(String.format("Option for value '%s' not found in datapoint '%s'", dp.getValue(), new HmDatapointInfo(dp)));
        }
        return new StringType(value);
    }
}

