/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.MqttBindingConstants;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.MqttChannelStateDescriptionProvider;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.MqttChannelTypeProvider;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.TransformationServiceProvider;
import org.eclipse.smarthome.binding.mqtt.generic.internal.handler.GenericThingHandler;
import org.eclipse.smarthome.binding.mqtt.generic.internal.handler.HomeAssistantThingHandler;
import org.eclipse.smarthome.binding.mqtt.generic.internal.handler.HomieThingHandler;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.transform.TransformationHelper;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ThingHandlerFactory.class})
@NonNullByDefault
public class MqttThingHandlerFactory
extends BaseThingHandlerFactory
implements TransformationServiceProvider {
    @NonNullByDefault(value={})
    private MqttChannelTypeProvider typeProvider;
    @NonNullByDefault(value={})
    private MqttChannelStateDescriptionProvider stateDescriptionProvider;
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Stream.of(MqttBindingConstants.GENERIC_MQTT_THING, MqttBindingConstants.HOMIE300_MQTT_THING, MqttBindingConstants.HOMEASSISTANT_MQTT_THING).collect(Collectors.toSet());

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        super.activate(componentContext);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        super.deactivate(componentContext);
    }

    @Reference
    protected void setStateDescriptionProvider(MqttChannelStateDescriptionProvider stateDescription) {
        this.stateDescriptionProvider = stateDescription;
    }

    protected void unsetStateDescriptionProvider(MqttChannelStateDescriptionProvider stateDescription) {
        this.stateDescriptionProvider = null;
    }

    @Reference
    protected void setChannelProvider(MqttChannelTypeProvider provider) {
        this.typeProvider = provider;
    }

    protected void unsetChannelProvider(MqttChannelTypeProvider provider) {
        this.typeProvider = null;
    }

    protected @Nullable ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID.equals((Object)MqttBindingConstants.GENERIC_MQTT_THING)) {
            return new GenericThingHandler(thing, this.stateDescriptionProvider, this, 1500);
        }
        if (thingTypeUID.equals((Object)MqttBindingConstants.HOMIE300_MQTT_THING)) {
            return new HomieThingHandler(thing, this.typeProvider, 1500, 200);
        }
        if (thingTypeUID.equals((Object)MqttBindingConstants.HOMEASSISTANT_MQTT_THING)) {
            return new HomeAssistantThingHandler(thing, this.typeProvider, 1500, 200);
        }
        return null;
    }

    @Override
    public @Nullable TransformationService getTransformationService(String type) {
        return TransformationHelper.getTransformationService((BundleContext)this.bundleContext, (String)type);
    }
}

