/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.AbstractComponent;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelConfigBuilder;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelState;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.StateChannelTypeBuilder;
import org.eclipse.smarthome.core.thing.type.TriggerChannelTypeBuilder;

@NonNullByDefault
public class CChannel {
    public final ChannelUID channelUID;
    public final ChannelState channelState;
    public final Channel channel;
    public final ChannelType type;
    public final ChannelTypeUID channelTypeUID;

    public CChannel(AbstractComponent component, String channelID, Value valueState, @Nullable String state_topic, @Nullable String command_topic, String label, String unit, @Nullable ChannelStateUpdateListener channelStateUpdateListener) {
        this.channelUID = new ChannelUID(component.channelGroupUID, channelID);
        this.channelTypeUID = component.haID.getChannelTypeID(channelID);
        this.channelState = new ChannelState(ChannelConfigBuilder.create().withRetain(true).withStateTopic(state_topic).withCommandTopic(command_topic).build(), this.channelUID, valueState, channelStateUpdateListener);
        this.type = StringUtils.isBlank((String)state_topic) ? ((TriggerChannelTypeBuilder)ChannelTypeBuilder.trigger((ChannelTypeUID)this.channelTypeUID, (String)label).withConfigDescriptionURI(URI.create("mqtt:ha_channel"))).build() : ((StateChannelTypeBuilder)ChannelTypeBuilder.state((ChannelTypeUID)this.channelTypeUID, (String)label, (String)this.channelState.getItemType()).withConfigDescriptionURI(URI.create("mqtt:ha_channel"))).withStateDescription(valueState.createStateDescription(unit, command_topic == null)).build();
        Configuration configuration = new Configuration();
        configuration.put("config", (Object)component.configJson);
        this.channel = ChannelBuilder.create((ChannelUID)this.channelUID, (String)this.channelState.getItemType()).withType(this.channelTypeUID).withKind(this.type.getKind()).withLabel(label).withConfiguration(configuration).build();
    }
}

