/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import com.google.gson.Gson;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.AbstractComponent;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.ComponentAlarmControlPanel;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.ComponentBinarySensor;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.ComponentCamera;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.ComponentClimate;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.ComponentCover;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.ComponentFan;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.ComponentLight;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.ComponentLock;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.ComponentSensor;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.ComponentSwitch;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class CFactory {
    private static final Logger logger = LoggerFactory.getLogger(CFactory.class);

    public static @Nullable AbstractComponent createComponent(ThingUID thingUID, HaID haID, String configJSON, @Nullable ChannelStateUpdateListener updateListener, Gson gson) {
        try {
            switch (haID.component) {
                case "alarm_control_panel": {
                    return new ComponentAlarmControlPanel(thingUID, haID, configJSON, updateListener, gson);
                }
                case "binary_sensor": {
                    return new ComponentBinarySensor(thingUID, haID, configJSON, updateListener, gson);
                }
                case "camera": {
                    return new ComponentCamera(thingUID, haID, configJSON, updateListener, gson);
                }
                case "cover": {
                    return new ComponentCover(thingUID, haID, configJSON, updateListener, gson);
                }
                case "fan": {
                    return new ComponentFan(thingUID, haID, configJSON, updateListener, gson);
                }
                case "climate": {
                    return new ComponentClimate(thingUID, haID, configJSON, updateListener, gson);
                }
                case "light": {
                    return new ComponentLight(thingUID, haID, configJSON, updateListener, gson);
                }
                case "lock": {
                    return new ComponentLock(thingUID, haID, configJSON, updateListener, gson);
                }
                case "sensor": {
                    return new ComponentSensor(thingUID, haID, configJSON, updateListener, gson);
                }
                case "switch": {
                    return new ComponentSwitch(thingUID, haID, configJSON, updateListener, gson);
                }
            }
        }
        catch (UnsupportedOperationException e) {
            logger.warn("Not supported", (Throwable)e);
        }
        return null;
    }

    public static @Nullable AbstractComponent createComponent(String basetopic, Channel channel, @Nullable ChannelStateUpdateListener updateListener, Gson gson) {
        HaID haID = new HaID(basetopic, channel.getUID());
        ThingUID thingUID = channel.getUID().getThingUID();
        String configJSON = (String)channel.getConfiguration().get("config");
        if (configJSON == null) {
            logger.warn("Provided channel does not have a 'config' configuration key!");
            return null;
        }
        try {
            switch (haID.component) {
                case "alarm_control_panel": {
                    return new ComponentAlarmControlPanel(thingUID, haID, configJSON, updateListener, gson);
                }
                case "binary_sensor": {
                    return new ComponentBinarySensor(thingUID, haID, configJSON, updateListener, gson);
                }
                case "camera": {
                    return new ComponentCamera(thingUID, haID, configJSON, updateListener, gson);
                }
                case "cover": {
                    return new ComponentCover(thingUID, haID, configJSON, updateListener, gson);
                }
                case "fan": {
                    return new ComponentFan(thingUID, haID, configJSON, updateListener, gson);
                }
                case "climate": {
                    return new ComponentClimate(thingUID, haID, configJSON, updateListener, gson);
                }
                case "light": {
                    return new ComponentLight(thingUID, haID, configJSON, updateListener, gson);
                }
                case "lock": {
                    return new ComponentLock(thingUID, haID, configJSON, updateListener, gson);
                }
                case "sensor": {
                    return new ComponentSensor(thingUID, haID, configJSON, updateListener, gson);
                }
                case "switch": {
                    return new ComponentSwitch(thingUID, haID, configJSON, updateListener, gson);
                }
            }
        }
        catch (UnsupportedOperationException e) {
            logger.warn("Not supported", (Throwable)e);
        }
        return null;
    }
}

