/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.discovery;

import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.discovery.MQTTTopicDiscoveryParticipant;
import org.eclipse.smarthome.binding.mqtt.discovery.MQTTTopicDiscoveryService;
import org.eclipse.smarthome.binding.mqtt.generic.internal.MqttBindingConstants;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.discovery.AbstractMQTTDiscovery;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DiscoveryService.class}, configurationPid="discovery.mqttha")
@NonNullByDefault
public class HomeAssistantDiscovery
extends AbstractMQTTDiscovery {
    private final Logger logger = LoggerFactory.getLogger(HomeAssistantDiscovery.class);
    protected final Map<String, Set<String>> componentsPerThingID = new TreeMap<String, Set<String>>();
    private @Nullable ScheduledFuture<?> future;
    public static final Map<String, String> HA_COMP_TO_NAME = new TreeMap<String, String>();
    static final String BASE_TOPIC = "homeassistant";
    @NonNullByDefault(value={})
    protected MQTTTopicDiscoveryService mqttTopicDiscovery;

    public HomeAssistantDiscovery() {
        super(Stream.of(MqttBindingConstants.HOMEASSISTANT_MQTT_THING).collect(Collectors.toSet()), 3, true, "homeassistant/#");
        HA_COMP_TO_NAME.put("alarm_control_panel", "Alarm Control Panel");
        HA_COMP_TO_NAME.put("binary_sensor", "Sensor");
        HA_COMP_TO_NAME.put("camera", "Camera");
        HA_COMP_TO_NAME.put("cover", "Blind");
        HA_COMP_TO_NAME.put("fan", "Fan");
        HA_COMP_TO_NAME.put("climate", "Climate Control");
        HA_COMP_TO_NAME.put("light", "Light");
        HA_COMP_TO_NAME.put("lock", "Lock");
        HA_COMP_TO_NAME.put("sensor", "Sensor");
        HA_COMP_TO_NAME.put("switch", "Switch");
    }

    @Reference
    public void setMQTTTopicDiscoveryService(MQTTTopicDiscoveryService service) {
        this.mqttTopicDiscovery = service;
    }

    public void unsetMQTTTopicDiscoveryService(@Nullable MQTTTopicDiscoveryService service) {
        this.mqttTopicDiscovery.unsubscribe((MQTTTopicDiscoveryParticipant)this);
        this.mqttTopicDiscovery = null;
    }

    @Override
    protected MQTTTopicDiscoveryService getDiscoveryService() {
        return this.mqttTopicDiscovery;
    }

    public static HaID determineTopicParts(String topic) {
        return new HaID(topic);
    }

    public static boolean checkVersion(String versionString) {
        String[] strings = versionString.split("\\.");
        if (strings.length < 2) {
            return false;
        }
        return strings[0].equals("3");
    }

    public void receivedMessage(ThingUID connectionBridge, MqttBrokerConnection connection, String topic, byte[] payload) {
        if (!topic.endsWith("/config")) {
            return;
        }
        HaID topicParts = HomeAssistantDiscovery.determineTopicParts(topic);
        String thingID = topicParts.getThingID();
        ThingUID thingUID = new ThingUID(MqttBindingConstants.HOMEASSISTANT_MQTT_THING, connectionBridge, thingID);
        ScheduledFuture<?> future = this.future;
        if (future != null) {
            future.cancel(false);
        }
        this.future = this.scheduler.schedule(this.componentsPerThingID::clear, 2L, TimeUnit.SECONDS);
        Set components = this.componentsPerThingID.getOrDefault(thingID, new HashSet());
        if (components.contains(topicParts.component)) {
            this.logger.trace("Discovered an already known component {}", (Object)topicParts.component);
            return;
        }
        components.add(topicParts.component);
        this.componentsPerThingID.put(thingID, components);
        String componentNames = components.stream().map(c -> HA_COMP_TO_NAME.getOrDefault(c, (String)c)).collect(Collectors.joining(","));
        Config config = (Config)new Gson().fromJson(new String(payload, StandardCharsets.UTF_8), Config.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("objectid", topicParts.objectID);
        properties.put("nodeid", topicParts.nodeID);
        properties.put("basetopic", BASE_TOPIC);
        this.thingRemoved(thingUID);
        this.thingDiscovered(DiscoveryResultBuilder.create((ThingUID)thingUID).withProperties(properties).withRepresentationProperty("objectid").withBridge(connectionBridge).withLabel(String.valueOf(config.name) + " (" + componentNames + ")").build());
    }

    public void topicVanished(ThingUID connectionBridge, MqttBrokerConnection connection, String topic) {
        if (!topic.endsWith("/config")) {
            return;
        }
        String thingID = HomeAssistantDiscovery.determineTopicParts(topic).getThingID();
        this.componentsPerThingID.remove(thingID);
        this.thingRemoved(new ThingUID(MqttBindingConstants.HOMEASSISTANT_MQTT_THING, connectionBridge, thingID));
    }

    private static class Config {
        String name = "";

        private Config() {
        }
    }
}

