/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.generic;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(immediate=false, service={ChannelTypeProvider.class, ChannelGroupTypeProvider.class, MqttChannelTypeProvider.class})
public class MqttChannelTypeProvider
implements ChannelGroupTypeProvider,
ChannelTypeProvider {
    private final Map<ChannelTypeUID, ChannelType> types = new HashMap<ChannelTypeUID, ChannelType>();
    private final Map<ChannelGroupTypeUID, ChannelGroupType> groups = new HashMap<ChannelGroupTypeUID, ChannelGroupType>();

    public @Nullable Collection<@NonNull ChannelType> getChannelTypes(@Nullable Locale locale) {
        return this.types.values();
    }

    public @Nullable ChannelType getChannelType(@NonNull ChannelTypeUID channelTypeUID, @Nullable Locale locale) {
        return this.types.get(channelTypeUID);
    }

    public @Nullable ChannelGroupType getChannelGroupType(@NonNull ChannelGroupTypeUID channelGroupTypeUID, @Nullable Locale locale) {
        return this.groups.get(channelGroupTypeUID);
    }

    public @Nullable Collection<@NonNull ChannelGroupType> getChannelGroupTypes(@Nullable Locale locale) {
        return this.groups.values();
    }

    public void removeChannelType(ChannelTypeUID uid) {
        this.types.remove(uid);
    }

    public void removeChannelGroupType(ChannelGroupTypeUID uid) {
        this.groups.remove(uid);
    }

    public void setChannelGroupType(ChannelGroupTypeUID uid, ChannelGroupType type) {
        this.groups.put(uid, type);
    }

    public void setChannelType(ChannelTypeUID uid, ChannelType type) {
        this.types.put(uid, type);
    }
}

