/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.handler;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.AbstractComponent;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.CChannel;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.CFactory;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.DiscoverComponents;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HandlerConfiguration;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelState;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.MqttChannelTypeProvider;
import org.eclipse.smarthome.binding.mqtt.generic.internal.handler.AbstractMQTTThingHandler;
import org.eclipse.smarthome.binding.mqtt.generic.internal.tools.DelayedBatchProcessing;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class HomeAssistantThingHandler
extends AbstractMQTTThingHandler
implements DiscoverComponents.ComponentDiscovered,
Consumer<List<AbstractComponent>> {
    private final Logger logger = LoggerFactory.getLogger(HomeAssistantThingHandler.class);
    protected final MqttChannelTypeProvider channelTypeProvider;
    public final int attributeReceiveTimeout;
    protected final DelayedBatchProcessing<AbstractComponent> delayedProcessing;
    protected final DiscoverComponents discoverComponents;
    private final Gson gson = new Gson();
    protected final Map<String, AbstractComponent> haComponents = new HashMap<String, AbstractComponent>();
    protected HandlerConfiguration config = new HandlerConfiguration();
    private HaID discoveryHomeAssistantID = new HaID("", "", "", "");

    public HomeAssistantThingHandler(Thing thing, MqttChannelTypeProvider channelTypeProvider, int subscribeTimeout, int attributeReceiveTimeout) {
        super(thing, subscribeTimeout);
        this.channelTypeProvider = channelTypeProvider;
        this.attributeReceiveTimeout = attributeReceiveTimeout;
        this.delayedProcessing = new DelayedBatchProcessing<AbstractComponent>(attributeReceiveTimeout, this, this.scheduler);
        this.discoverComponents = new DiscoverComponents(thing.getUID(), this.scheduler, this, this.gson);
    }

    @Override
    public void initialize() {
        this.config = (HandlerConfiguration)this.getConfigAs(HandlerConfiguration.class);
        if (this.config.objectid.isEmpty()) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Device ID unknown");
            return;
        }
        this.discoveryHomeAssistantID = new HaID(this.config.basetopic, this.config.objectid, "", "");
        for (Channel channel : this.thing.getChannels()) {
            String groupID = channel.getUID().getGroupId();
            if (groupID == null) {
                this.logger.warn("Channel {} has no groupd ID", (Object)channel.getLabel());
                continue;
            }
            @Nullable AbstractComponent component = this.haComponents.get(groupID);
            if (component != null) continue;
            component = CFactory.createComponent(this.config.basetopic, channel, this, this.gson);
            if (component != null) {
                this.haComponents.put(component.uid().getId(), component);
                component.addChannelTypes(this.channelTypeProvider);
                continue;
            }
            this.logger.warn("Could not restore component {}", (Object)this.thing);
        }
        super.initialize();
    }

    @Override
    public void dispose() {
        this.discoverComponents.stopDiscovery();
        this.delayedProcessing.join();
        this.haComponents.values().forEach(c -> c.removeChannelTypes(this.channelTypeProvider));
        try {
            this.haComponents.values().stream().map(e -> e.stop()).reduce(CompletableFuture.completedFuture(null), (a, v) -> a.thenCompose(b -> v)).get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {}
        super.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected CompletableFuture<@Nullable Void> start(MqttBrokerConnection connection) {
        connection.setRetain(true);
        connection.setQos(1);
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.GONE, "No response from the device yet");
        @Nullable CompletionStage future = this.haComponents.values().stream().map(e -> e.start(connection, this.scheduler, this.attributeReceiveTimeout)).reduce(CompletableFuture.completedFuture(null), (a, v) -> a.thenCompose(b -> v)).exceptionally(e -> {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
            return null;
        });
        return ((CompletableFuture)future).thenCompose(b -> this.discoverComponents.startDiscovery(connection, 0, this.discoveryHomeAssistantID, this));
    }

    @Override
    protected void stop() {
        this.discoverComponents.stopDiscovery();
        this.delayedProcessing.join();
        this.haComponents.values().stream().map(e -> e.stop());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable ChannelState getChannelState(ChannelUID channelUID) {
        AbstractComponent component;
        String groupID = channelUID.getGroupId();
        if (groupID == null) {
            return null;
        }
        Map<String, AbstractComponent> map = this.haComponents;
        synchronized (map) {
            component = this.haComponents.get(groupID);
        }
        if (component == null) {
            return null;
        }
        CChannel componentChannel = component.channel(channelUID.getIdWithoutGroup());
        if (componentChannel == null) {
            return null;
        }
        return componentChannel.channelState;
    }

    @Override
    public void componentDiscovered(HaID homeAssistantTopicID, AbstractComponent component) {
        this.delayedProcessing.accept(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(List<AbstractComponent> discoveredComponentsList) {
        MqttBrokerConnection connection = this.connection;
        if (connection == null) {
            return;
        }
        ArrayList<Channel> channels = new ArrayList<Channel>();
        Map<String, AbstractComponent> map = this.haComponents;
        synchronized (map) {
            for (AbstractComponent discovered : discoveredComponentsList) {
                AbstractComponent known = this.haComponents.get(discovered.uid().getId());
                if (known != null) {
                    if (discovered.getConfigHash() == known.getConfigHash()) continue;
                    known.stop();
                }
                this.channelTypeProvider.setChannelGroupType(discovered.groupTypeUID(), discovered.type());
                discovered.addChannelTypes(this.channelTypeProvider);
                this.haComponents.put(discovered.uid().getId(), discovered);
                discovered.start(connection, this.scheduler, 0).exceptionally(e -> {
                    this.logger.warn("Failed to start component {}", (Object)discovered.uid(), e);
                    return null;
                });
            }
            for (AbstractComponent e2 : this.haComponents.values()) {
                for (CChannel entry : e2.channelTypes().values()) {
                    channels.add(entry.channel);
                }
            }
        }
        this.updateThing(this.editThing().withChannels(channels).build());
        this.updateStatus(ThingStatus.ONLINE);
    }
}

