/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.mapping;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.mapping.MandatoryField;
import org.eclipse.smarthome.binding.mqtt.generic.internal.mapping.SubscribeFieldToMQTTtopic;
import org.eclipse.smarthome.binding.mqtt.generic.internal.mapping.TopicPrefix;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractMqttAttributeClass
implements SubscribeFieldToMQTTtopic.FieldChanged {
    private final Logger logger = LoggerFactory.getLogger(AbstractMqttAttributeClass.class);
    protected transient List<SubscribeFieldToMQTTtopic> subscriptions = new ArrayList<SubscribeFieldToMQTTtopic>();
    public transient WeakReference<@Nullable MqttBrokerConnection> connection = new WeakReference<Object>(null);
    protected transient WeakReference<@Nullable ScheduledExecutorService> scheduler = new WeakReference<Object>(null);
    private final String prefix;
    private transient String basetopic = "";
    protected transient AttributeChanged attributeChangedListener = (b, c, d, e, f) -> {};
    private transient boolean complete = false;

    protected AbstractMqttAttributeClass() {
        TopicPrefix topicUsesPrefix = this.getFieldsOf().getClass().getAnnotation(TopicPrefix.class);
        this.prefix = topicUsesPrefix != null ? topicUsesPrefix.value() : "";
    }

    public CompletableFuture<@Nullable Void> unsubscribe() {
        MqttBrokerConnection connection = (MqttBrokerConnection)this.connection.get();
        if (connection == null) {
            this.subscriptions.clear();
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture[] futures = (CompletableFuture[])this.subscriptions.stream().map(m -> connection.unsubscribe(m.topic, (MqttMessageSubscriber)m)).toArray(CompletableFuture[]::new);
        this.subscriptions.clear();
        return CompletableFuture.allOf(futures);
    }

    public CompletableFuture<@Nullable Void> subscribeAndReceive(MqttBrokerConnection connection, ScheduledExecutorService scheduler, String basetopic, @Nullable AttributeChanged attributeChangedListener, int timeout) {
        CompletableFuture<@Nullable Void> startFuture = this.subscriptions.size() > 0 ? this.unsubscribe() : CompletableFuture.completedFuture(null);
        this.connection = new WeakReference<MqttBrokerConnection>(connection);
        this.scheduler = new WeakReference<ScheduledExecutorService>(scheduler);
        this.basetopic = basetopic;
        this.attributeChangedListener = attributeChangedListener != null ? attributeChangedListener : (b, c, d, e, f) -> {};
        this.subscriptions = AbstractMqttAttributeClass.getAllFields(this.getFieldsOf().getClass()).stream().filter(AbstractMqttAttributeClass::filterField).map(this::mapFieldToSubscriber).collect(Collectors.toList());
        CompletableFuture[] futures = (CompletableFuture[])this.subscriptions.stream().map(m -> m.subscribeAndReceive(connection, timeout)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(startFuture, CompletableFuture.allOf(futures));
    }

    protected static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> currentClass = clazz;
        while (currentClass != null) {
            fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
            currentClass = currentClass.getSuperclass();
        }
        return fields;
    }

    protected static boolean filterField(Field field) {
        return !Modifier.isFinal(field.getModifiers()) && !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers());
    }

    protected SubscribeFieldToMQTTtopic mapFieldToSubscriber(Field field) {
        ScheduledExecutorService scheduler = (ScheduledExecutorService)this.scheduler.get();
        if (scheduler == null) {
            throw new IllegalStateException("No scheduler set!");
        }
        MandatoryField mandatoryField = field.getAnnotation(MandatoryField.class);
        boolean mandatory = mandatoryField != null;
        TopicPrefix topicUsesPrefix = field.getAnnotation(TopicPrefix.class);
        String localPrefix = topicUsesPrefix != null ? topicUsesPrefix.value() : this.prefix;
        String topic = String.valueOf(this.basetopic) + "/" + localPrefix + field.getName();
        return this.createSubscriber(scheduler, field, topic, mandatory);
    }

    public SubscribeFieldToMQTTtopic createSubscriber(ScheduledExecutorService scheduler, Field field, String topic, boolean mandatory) {
        return new SubscribeFieldToMQTTtopic(scheduler, field, this, topic, mandatory);
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void fieldChanged(Field field, Object value) {
        MqttBrokerConnection connection = (MqttBrokerConnection)this.connection.get();
        ScheduledExecutorService scheduler = (ScheduledExecutorService)this.scheduler.get();
        if (connection == null || scheduler == null) {
            this.logger.warn("No connection or scheduler set!");
            return;
        }
        try {
            field.set(this.getFieldsOf(), value);
            boolean newComplete = !this.subscriptions.stream().anyMatch(s -> s.isMandatory() && !s.hasReceivedValue());
            this.attributeChangedListener.attributeChanged(field.getName(), value, connection, scheduler, newComplete);
            this.complete = newComplete;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.logger.warn("Could not assign value {} to field {}", new Object[]{value, field, e});
        }
    }

    public abstract Object getFieldsOf();

    public static interface AttributeChanged {
        public void attributeChanged(String var1, Object var2, MqttBrokerConnection var3, ScheduledExecutorService var4, boolean var5);
    }
}

