/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.math.BigDecimal;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class ColorValue
extends Value {
    private final boolean isRGB;
    private final String onValue;
    private final String offValue;
    private final int onBrightness;
    private static BigDecimal factor = new BigDecimal(2.5);

    public ColorValue(boolean isRGB, @Nullable String onValue, @Nullable String offValue, int onBrightness) {
        super("Color", Stream.of(OnOffType.class, PercentType.class, StringType.class).collect(Collectors.toList()));
        if (onBrightness > 100) {
            throw new IllegalArgumentException("Brightness parameter must be <= 100");
        }
        this.isRGB = isRGB;
        this.onValue = onValue == null ? "ON" : onValue;
        this.offValue = offValue == null ? "OFF" : offValue;
        this.onBrightness = onBrightness;
    }

    @Override
    public void update(Command command) throws IllegalArgumentException {
        HSBType oldvalue;
        HSBType hSBType = oldvalue = this.state == UnDefType.UNDEF ? new HSBType() : (HSBType)this.state;
        if (command instanceof HSBType) {
            this.state = (HSBType)command;
        } else if (command instanceof OnOffType) {
            OnOffType boolValue = (OnOffType)command;
            PercentType minOn = new PercentType(Math.max(oldvalue.getBrightness().intValue(), this.onBrightness));
            this.state = new HSBType(oldvalue.getHue(), oldvalue.getSaturation(), boolValue == OnOffType.ON ? minOn : new PercentType(0));
        } else if (command instanceof PercentType) {
            this.state = new HSBType(oldvalue.getHue(), oldvalue.getSaturation(), (PercentType)command);
        } else {
            String updatedValue = command.toString();
            if (this.onValue.equals(updatedValue)) {
                PercentType minOn = new PercentType(Math.max(oldvalue.getBrightness().intValue(), this.onBrightness));
                this.state = new HSBType(oldvalue.getHue(), oldvalue.getSaturation(), minOn);
            } else if (this.offValue.equals(updatedValue)) {
                this.state = new HSBType(oldvalue.getHue(), oldvalue.getSaturation(), new PercentType(0));
            } else if (this.isRGB) {
                String[] split = updatedValue.split(",");
                if (split.length != 3) {
                    throw new IllegalArgumentException(String.valueOf(updatedValue) + " is not a valid RGB syntax");
                }
                this.state = HSBType.fromRGB((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[2]));
            } else {
                this.state = new HSBType(updatedValue);
            }
        }
    }

    @Override
    public String getMQTTpublishValue() {
        if (this.state == UnDefType.UNDEF) {
            return "";
        }
        if (this.isRGB) {
            PercentType[] rgb = ((HSBType)this.state).toRGB();
            StringBuilder b = new StringBuilder();
            b.append(rgb[0].toBigDecimal().multiply(factor).intValue());
            b.append(',');
            b.append(rgb[1].toBigDecimal().multiply(factor).intValue());
            b.append(',');
            b.append(rgb[2].toBigDecimal().multiply(factor).intValue());
            return b.toString();
        }
        return this.state.toString();
    }
}

