/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;

@NonNullByDefault
public class OpenCloseValue
extends Value {
    private final String openString;
    private final String closeString;

    public OpenCloseValue() {
        super("Contact", Stream.of(OpenClosedType.class, StringType.class).collect(Collectors.toList()));
        this.openString = OpenClosedType.OPEN.name();
        this.closeString = OpenClosedType.CLOSED.name();
    }

    public OpenCloseValue(@Nullable String openValue, @Nullable String closeValue) {
        super("Contact", Stream.of(OpenClosedType.class, StringType.class).collect(Collectors.toList()));
        this.openString = openValue == null ? OpenClosedType.OPEN.name() : openValue;
        this.closeString = closeValue == null ? OpenClosedType.CLOSED.name() : closeValue;
    }

    @Override
    public void update(Command command) throws IllegalArgumentException {
        String updatedValue;
        this.state = command instanceof OpenClosedType ? (OpenClosedType)command : (this.openString.equals(updatedValue = command.toString()) ? OpenClosedType.OPEN : (this.closeString.equals(updatedValue) ? OpenClosedType.CLOSED : OpenClosedType.valueOf((String)updatedValue)));
    }

    @Override
    public String getMQTTpublishValue() {
        return this.state == OpenClosedType.OPEN ? this.openString : this.closeString;
    }
}

