/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StopMoveType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class RollershutterValue
extends Value {
    private final @Nullable String upString;
    private final @Nullable String downString;
    private final @Nullable String stopString;

    public RollershutterValue(@Nullable String upString, @Nullable String downString, @Nullable String stopString) {
        super("Rollershutter", Stream.of(UpDownType.class, StopMoveType.class, PercentType.class, StringType.class).collect(Collectors.toList()));
        this.upString = upString;
        this.downString = downString;
        this.stopString = stopString;
    }

    @Override
    public void update(Command command) throws IllegalArgumentException {
        if (command instanceof StopMoveType) {
            throw new IllegalStateException("Cannot call update() with StopMoveType");
        }
        if (!(command instanceof PercentType)) {
            throw new IllegalStateException("Cannot call update() with custom stop/move/up/down");
        }
        this.state = (PercentType)command;
    }

    @Override
    public @Nullable Command isPostOnly(Command command) {
        if (command instanceof UpDownType) {
            return command;
        }
        if (command instanceof StopMoveType) {
            return command;
        }
        if (command instanceof StringType) {
            String updatedValue = command.toString();
            if (updatedValue.equals(this.upString)) {
                return (Command)UpDownType.UP.as(PercentType.class);
            }
            if (updatedValue.equals(this.downString)) {
                return (Command)UpDownType.DOWN.as(PercentType.class);
            }
            if (updatedValue.equals(this.stopString)) {
                return StopMoveType.STOP;
            }
        }
        return null;
    }

    @Override
    public String getMQTTpublishValue() {
        return this.state == UnDefType.UNDEF ? "0" : String.valueOf(((PercentType)this.state).intValue());
    }
}

