/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonyaudio.handler;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.smarthome.binding.sonyaudio.internal.SonyAudioEventListener;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SonyAudioConnection;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.cache.ExpiringCache;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SonyAudioHandler
extends BaseThingHandler
implements SonyAudioEventListener {
    private final Logger logger = LoggerFactory.getLogger(SonyAudioHandler.class);
    private WebSocketClient webSocketClient;
    protected SonyAudioConnection connection;
    private ScheduledFuture<?> connectionCheckerFuture;
    private ScheduledFuture<?> refreshJob;
    private int currentRadioStation = 0;
    private final Map<Integer, String> input_zone = new HashMap<Integer, String>();
    private static final long CACHE_EXPIRY = TimeUnit.SECONDS.toMillis(5L);
    protected ExpiringCache<Boolean>[] powerCache;
    protected ExpiringCache<SonyAudioConnection.SonyAudioInput>[] inputCache;
    protected ExpiringCache<SonyAudioConnection.SonyAudioVolume>[] volumeCache;
    protected ExpiringCache<Map<String, String>> soundSettingsCache;
    protected Supplier<Boolean>[] powerSupplier;
    protected Supplier<SonyAudioConnection.SonyAudioInput>[] inputSupplier;
    protected Supplier<SonyAudioConnection.SonyAudioVolume>[] volumeSupplier;
    protected Supplier<Map<String, String>> soundSettingsSupplier;

    public SonyAudioHandler(Thing thing, WebSocketClient webSocketClient) {
        super(thing);
        this.webSocketClient = webSocketClient;
        this.powerCache = new ExpiringCache[5];
        this.powerSupplier = new Supplier[5];
        this.inputCache = new ExpiringCache[5];
        this.inputSupplier = new Supplier[5];
        this.volumeCache = new ExpiringCache[5];
        this.volumeSupplier = new Supplier[5];
        int i = 0;
        while (i < 5) {
            int index = i;
            this.inputSupplier[i] = () -> {
                try {
                    return this.connection.getInput(index);
                }
                catch (IOException ex) {
                    throw new CompletionException(ex);
                }
            };
            this.powerSupplier[i] = () -> {
                try {
                    return this.connection.getPower(index);
                }
                catch (IOException ex) {
                    throw new CompletionException(ex);
                }
            };
            this.volumeSupplier[i] = () -> {
                try {
                    return this.connection.getVolume(index);
                }
                catch (IOException ex) {
                    throw new CompletionException(ex);
                }
            };
            this.powerCache[i] = new ExpiringCache(CACHE_EXPIRY, this.powerSupplier[i]);
            this.inputCache[i] = new ExpiringCache(CACHE_EXPIRY, this.inputSupplier[i]);
            this.volumeCache[i] = new ExpiringCache(CACHE_EXPIRY, this.volumeSupplier[i]);
            ++i;
        }
        this.soundSettingsSupplier = () -> {
            try {
                return this.connection.getSoundSettings();
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        };
        this.soundSettingsCache = new ExpiringCache(CACHE_EXPIRY, this.soundSettingsSupplier);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        String id;
        block92: {
            if (this.connection == null || !this.connection.checkConnection()) {
                this.logger.debug("Thing not yet initialized!");
                return;
            }
            id = channelUID.getId();
            this.logger.debug("Handle command {} {}", (Object)channelUID, (Object)command);
            if (this.getThing().getStatusInfo().getStatus() == ThingStatus.ONLINE) break block92;
            switch (id) {
                case "power": 
                case "master#power": {
                    this.logger.debug("Device powered off sending {} {}", (Object)channelUID, (Object)command);
                    break;
                }
                default: {
                    this.logger.debug("Device powered off ignore command {} {}", (Object)channelUID, (Object)command);
                    return;
                }
            }
        }
        try {
            switch (id) {
                case "power": 
                case "master#power": {
                    this.handlePowerCommand(command, channelUID);
                    break;
                }
                case "zone1#power": {
                    this.handlePowerCommand(command, channelUID, 1);
                    break;
                }
                case "zone2#power": {
                    this.handlePowerCommand(command, channelUID, 2);
                    break;
                }
                case "zone3#power": {
                    this.handlePowerCommand(command, channelUID, 3);
                    break;
                }
                case "zone4#power": {
                    this.handlePowerCommand(command, channelUID, 4);
                    break;
                }
                case "input": {
                    this.handleInputCommand(command, channelUID);
                    break;
                }
                case "zone1#input": {
                    this.handleInputCommand(command, channelUID, 1);
                    break;
                }
                case "zone2#input": {
                    this.handleInputCommand(command, channelUID, 2);
                    break;
                }
                case "zone3#input": {
                    this.handleInputCommand(command, channelUID, 3);
                    break;
                }
                case "zone4#input": {
                    this.handleInputCommand(command, channelUID, 4);
                    break;
                }
                case "volume": {
                    this.handleVolumeCommand(command, channelUID);
                    break;
                }
                case "zone1#volume": {
                    this.handleVolumeCommand(command, channelUID, 1);
                    break;
                }
                case "zone2#volume": {
                    this.handleVolumeCommand(command, channelUID, 2);
                    break;
                }
                case "zone3#volume": {
                    this.handleVolumeCommand(command, channelUID, 3);
                    break;
                }
                case "zone4#volume": {
                    this.handleVolumeCommand(command, channelUID, 4);
                    break;
                }
                case "mute": {
                    this.handleMuteCommand(command, channelUID);
                    break;
                }
                case "zone1#mute": {
                    this.handleMuteCommand(command, channelUID, 1);
                    break;
                }
                case "zone2#mute": {
                    this.handleMuteCommand(command, channelUID, 2);
                    break;
                }
                case "zone3#mute": {
                    this.handleMuteCommand(command, channelUID, 3);
                    break;
                }
                case "zone4#mute": {
                    this.handleMuteCommand(command, channelUID, 4);
                    break;
                }
                case "soundField": 
                case "master#soundField": {
                    this.handleSoundSettings(command, channelUID);
                    break;
                }
                case "radio#broadcastFreq": {
                    this.handleRadioCommand(command, channelUID);
                    break;
                }
                case "radio#broadcastStation": {
                    this.handleRadioStationCommand(command, channelUID);
                    break;
                }
                case "radio#broadcastSeekStation": {
                    this.handleRadioSeekStationCommand(command, channelUID);
                    break;
                }
                default: {
                    this.logger.error("Channel {} not supported!", (Object)id);
                    break;
                }
            }
        }
        catch (IOException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
        }
    }

    public void handleSoundSettings(Command command, ChannelUID channelUID) throws IOException {
        if (command instanceof RefreshType) {
            this.logger.debug("handleSoundSettings RefreshType");
            Map result = (Map)this.soundSettingsCache.getValue();
            if (result != null) {
                this.updateState(channelUID, (State)new StringType((String)result.get("soundField")));
            }
        }
        if (command instanceof StringType) {
            this.logger.debug("handleSoundSettings set {} {}", (Object)command);
            this.connection.setSoundSettings("soundField", ((StringType)command).toString());
        }
    }

    public void handlePowerCommand(Command command, ChannelUID channelUID) throws IOException {
        this.handlePowerCommand(command, channelUID, 0);
    }

    public void handlePowerCommand(Command command, ChannelUID channelUID, int zone) throws IOException {
        if (command instanceof RefreshType) {
            try {
                this.logger.debug("handlePowerCommand RefreshType {}", (Object)zone);
                Boolean result = (Boolean)this.powerCache[zone].getValue();
                this.updateState(channelUID, (State)(result != false ? OnOffType.ON : OnOffType.OFF));
            }
            catch (CompletionException ex) {
                throw new IOException(ex.getCause());
            }
        }
        if (command instanceof OnOffType) {
            this.logger.debug("handlePowerCommand set {} {}", (Object)zone, (Object)command);
            this.connection.setPower((OnOffType)command == OnOffType.ON, zone);
        }
    }

    public void handleInputCommand(Command command, ChannelUID channelUID) throws IOException {
        this.handleInputCommand(command, channelUID, 0);
    }

    public void handleInputCommand(Command command, ChannelUID channelUID, int zone) throws IOException {
        if (command instanceof RefreshType) {
            this.logger.debug("handleInputCommand RefreshType {}", (Object)zone);
            try {
                SonyAudioConnection.SonyAudioInput result = (SonyAudioConnection.SonyAudioInput)this.inputCache[zone].getValue();
                if (result != null) {
                    if (zone > 0) {
                        this.input_zone.put(zone, result.input);
                    }
                    this.updateState(channelUID, (State)this.inputSource(result.input));
                    if (result.radio_freq.isPresent()) {
                        this.updateState("radio#broadcastFreq", (State)new DecimalType((double)result.radio_freq.get().intValue() / 1000000.0));
                    }
                }
            }
            catch (CompletionException ex) {
                throw new IOException(ex.getCause());
            }
        }
        if (command instanceof StringType) {
            this.logger.debug("handleInputCommand set {} {}", (Object)zone, (Object)command);
            this.connection.setInput(this.setInputCommand(command), zone);
        }
    }

    public void handleVolumeCommand(Command command, ChannelUID channelUID) throws IOException {
        this.handleVolumeCommand(command, channelUID, 0);
    }

    public void handleVolumeCommand(Command command, ChannelUID channelUID, int zone) throws IOException {
        if (command instanceof RefreshType) {
            try {
                this.logger.debug("handleVolumeCommand RefreshType {}", (Object)zone);
                SonyAudioConnection.SonyAudioVolume result = (SonyAudioConnection.SonyAudioVolume)this.volumeCache[zone].getValue();
                if (result != null) {
                    this.updateState(channelUID, (State)new PercentType(result.volume.intValue()));
                }
            }
            catch (CompletionException ex) {
                throw new IOException(ex.getCause());
            }
        }
        if (command instanceof PercentType) {
            this.logger.debug("handleVolumeCommand PercentType set {} {}", (Object)zone, (Object)command);
            this.connection.setVolume(((PercentType)command).intValue(), zone);
        }
        if (command instanceof IncreaseDecreaseType) {
            this.logger.debug("handleVolumeCommand IncreaseDecreaseType set {} {}", (Object)zone, (Object)command);
            String change = command == IncreaseDecreaseType.INCREASE ? "+1" : "-1";
            this.connection.setVolume(change, zone);
        }
        if (command instanceof OnOffType) {
            this.logger.debug("handleVolumeCommand OnOffType set {} {}", (Object)zone, (Object)command);
            this.connection.setMute((OnOffType)command == OnOffType.ON, zone);
        }
    }

    public void handleMuteCommand(Command command, ChannelUID channelUID) throws IOException {
        this.handleMuteCommand(command, channelUID, 0);
    }

    public void handleMuteCommand(Command command, ChannelUID channelUID, int zone) throws IOException {
        if (command instanceof RefreshType) {
            try {
                this.logger.debug("handleMuteCommand RefreshType {}", (Object)zone);
                SonyAudioConnection.SonyAudioVolume result = (SonyAudioConnection.SonyAudioVolume)this.volumeCache[zone].getValue();
                if (result != null) {
                    this.updateState(channelUID, (State)(result.mute != false ? OnOffType.ON : OnOffType.OFF));
                }
            }
            catch (CompletionException ex) {
                throw new IOException(ex.getCause());
            }
        }
        if (command instanceof OnOffType) {
            this.logger.debug("handleMuteCommand set {} {}", (Object)zone, (Object)command);
            this.connection.setMute((OnOffType)command == OnOffType.ON, zone);
        }
    }

    public void handleRadioCommand(Command command, ChannelUID channelUID) throws IOException {
    }

    public void handleRadioStationCommand(Command command, ChannelUID channelUID) throws IOException {
        if (command instanceof RefreshType) {
            this.updateState(channelUID, (State)new DecimalType((long)this.currentRadioStation));
        }
        if (command instanceof DecimalType) {
            this.currentRadioStation = ((DecimalType)command).intValue();
            String radioCommand = "radio:fm?contentId=" + this.currentRadioStation;
            int i = 1;
            while (i <= 4) {
                String input = this.input_zone.get(i);
                if (input != null && input.startsWith("radio:fm")) {
                    this.connection.setInput(radioCommand, i);
                }
                ++i;
            }
        }
    }

    public void handleRadioSeekStationCommand(Command command, ChannelUID channelUID) throws IOException {
        block11: {
            if (command instanceof RefreshType) {
                this.updateState(channelUID, (State)new StringType(""));
            }
            if (!(command instanceof StringType)) break block11;
            switch (((StringType)command).toString()) {
                case "fwdSeeking": {
                    this.connection.radioSeekFwd();
                    break;
                }
                case "bwdSeeking": {
                    this.connection.radioSeekBwd();
                }
            }
        }
    }

    public abstract String setInputCommand(Command var1);

    public void initialize() {
        Configuration config = this.getThing().getConfiguration();
        String ipAddress = (String)config.get("ipAddress");
        String path = (String)config.get("path");
        Object port_o = config.get("port");
        int port = 10000;
        if (port_o instanceof BigDecimal) {
            port = ((BigDecimal)port_o).intValue();
        } else if (port_o instanceof Integer) {
            port = (Integer)port_o;
        }
        Object refresh_o = config.get("refreshInterval");
        int refresh = 0;
        if (refresh_o instanceof BigDecimal) {
            refresh = ((BigDecimal)refresh_o).intValue();
        } else if (refresh_o instanceof Integer) {
            refresh = (Integer)refresh_o;
        }
        try {
            this.connection = new SonyAudioConnection(ipAddress, port, path, this, this.scheduler, this.webSocketClient);
            Runnable connectionChecker = () -> {
                try {
                    if (!this.connection.checkConnection() && this.getThing().getStatus() != ThingStatus.OFFLINE) {
                        this.logger.debug("Lost connection");
                        this.updateStatus(ThingStatus.OFFLINE);
                    }
                }
                catch (Exception ex) {
                    this.logger.warn("Exception in check connection to @{}. Cause: {}", new Object[]{this.connection.getConnectionName(), ex.getMessage(), ex});
                }
            };
            this.connectionCheckerFuture = this.scheduler.scheduleWithFixedDelay(connectionChecker, 1L, 10L, TimeUnit.SECONDS);
            this.startAutomaticRefresh(refresh);
        }
        catch (URISyntaxException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
        }
    }

    public void dispose() {
        this.logger.debug("Disposing SonyAudioHandler");
        super.dispose();
        if (this.connectionCheckerFuture != null) {
            this.connectionCheckerFuture.cancel(true);
            this.connectionCheckerFuture = null;
        }
        if (this.refreshJob != null) {
            this.refreshJob.cancel(true);
            this.refreshJob = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    @Override
    public void updateConnectionState(boolean connected) {
        this.logger.debug("Changing connection status to {}", (Object)connected);
        if (connected) {
            this.updateStatus(ThingStatus.ONLINE);
        } else {
            this.updateStatus(ThingStatus.OFFLINE);
        }
    }

    @Override
    public void updateInput(int zone, SonyAudioConnection.SonyAudioInput input) {
        this.inputCache[zone].putValue((Object)input);
        switch (zone) {
            case 0: {
                this.updateState("input", (State)this.inputSource(input.input));
                break;
            }
            case 1: {
                this.updateState("zone1#input", (State)this.inputSource(input.input));
                break;
            }
            case 2: {
                this.updateState("zone2#input", (State)this.inputSource(input.input));
                break;
            }
            case 3: {
                this.updateState("zone3#input", (State)this.inputSource(input.input));
                break;
            }
            case 4: {
                this.updateState("zone4#input", (State)this.inputSource(input.input));
            }
        }
        if (input.radio_freq.isPresent()) {
            this.updateState("radio#broadcastFreq", (State)new DecimalType((double)input.radio_freq.get().intValue() / 1000000.0));
        }
    }

    public abstract StringType inputSource(String var1);

    @Override
    public void updateCurrentRadioStation(int radioStation) {
        this.currentRadioStation = radioStation;
        this.updateState("radio#broadcastStation", (State)new DecimalType((long)this.currentRadioStation));
    }

    @Override
    public void updateSeekStation(String seek) {
        this.updateState("radio#broadcastSeekStation", (State)new StringType(seek));
    }

    @Override
    public void updateVolume(int zone, SonyAudioConnection.SonyAudioVolume volume) {
        this.volumeCache[zone].putValue((Object)volume);
        switch (zone) {
            case 0: {
                this.updateState("volume", (State)new PercentType(volume.volume.intValue()));
                this.updateState("mute", (State)(volume.mute != false ? OnOffType.ON : OnOffType.OFF));
                break;
            }
            case 1: {
                this.updateState("zone1#volume", (State)new PercentType(volume.volume.intValue()));
                this.updateState("zone1#mute", (State)(volume.mute != false ? OnOffType.ON : OnOffType.OFF));
                break;
            }
            case 2: {
                this.updateState("zone2#volume", (State)new PercentType(volume.volume.intValue()));
                this.updateState("zone2#mute", (State)(volume.mute != false ? OnOffType.ON : OnOffType.OFF));
                break;
            }
            case 3: {
                this.updateState("zone3#volume", (State)new PercentType(volume.volume.intValue()));
                this.updateState("zone3#mute", (State)(volume.mute != false ? OnOffType.ON : OnOffType.OFF));
                break;
            }
            case 4: {
                this.updateState("zone4#volume", (State)new PercentType(volume.volume.intValue()));
                this.updateState("zone4#mute", (State)(volume.mute != false ? OnOffType.ON : OnOffType.OFF));
            }
        }
    }

    @Override
    public void updatePowerStatus(int zone, boolean power) {
        this.powerCache[zone].invalidateValue();
        switch (zone) {
            case 0: {
                this.updateState("power", (State)(power ? OnOffType.ON : OnOffType.OFF));
                this.updateState("master#power", (State)(power ? OnOffType.ON : OnOffType.OFF));
                break;
            }
            case 1: {
                this.updateState("zone1#power", (State)(power ? OnOffType.ON : OnOffType.OFF));
                break;
            }
            case 2: {
                this.updateState("zone2#power", (State)(power ? OnOffType.ON : OnOffType.OFF));
                break;
            }
            case 3: {
                this.updateState("zone3#power", (State)(power ? OnOffType.ON : OnOffType.OFF));
                break;
            }
            case 4: {
                this.updateState("zone4#power", (State)(power ? OnOffType.ON : OnOffType.OFF));
            }
        }
    }

    private void startAutomaticRefresh(int refresh) {
        if (refresh <= 0) {
            return;
        }
        this.refreshJob = this.scheduler.scheduleWithFixedDelay(() -> {
            List channels = this.getThing().getChannels();
            for (Channel channel : channels) {
                if (!this.isLinked(channel.getUID())) continue;
                this.handleCommand(channel.getUID(), (Command)RefreshType.REFRESH);
            }
        }, 5L, refresh, TimeUnit.SECONDS);
    }
}

