/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonyaudio.internal.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.smarthome.binding.sonyaudio.internal.SonyAudioEventListener;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.GetCurrentExternalTerminalsStatus;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.GetPlayingContentInfo;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.GetPowerStatus;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.GetSoundSettings;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.GetVolumeInformation;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SeekBroadcastStation;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SetActiveTerminal;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SetAudioMute;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SetAudioVolume;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SetPlayContent;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SetPowerStatus;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SetSoundSettings;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SonyAudioClientSocket;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SonyAudioClientSocketEventListener;
import org.eclipse.smarthome.binding.sonyaudio.internal.protocol.SwitchNotifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonyAudioConnection
implements SonyAudioClientSocketEventListener {
    private final Logger logger = LoggerFactory.getLogger(SonyAudioConnection.class);
    private final String host;
    private final int port;
    private final String path;
    private final URI base_uri;
    private final WebSocketClient webSocketClient;
    private SonyAudioClientSocket avContentSocket;
    private SonyAudioClientSocket audioSocket;
    private SonyAudioClientSocket systemSocket;
    private final SonyAudioEventListener listener;
    private int min_volume = 0;
    private int max_volume = 50;
    private final Gson gson;

    public SonyAudioConnection(String host, int port, String path, SonyAudioEventListener listener, ScheduledExecutorService scheduler, WebSocketClient webSocketClient) throws URISyntaxException {
        this.host = host;
        this.port = port;
        this.path = path;
        this.listener = listener;
        this.gson = new Gson();
        this.webSocketClient = webSocketClient;
        this.base_uri = new URI(String.format("ws://%s:%d/%s", host, port, path)).normalize();
        URI wsAvContentUri = this.base_uri.resolve(String.valueOf(this.base_uri.getPath()) + "/avContent").normalize();
        this.avContentSocket = new SonyAudioClientSocket(this, wsAvContentUri, scheduler);
        URI wsAudioUri = this.base_uri.resolve(String.valueOf(this.base_uri.getPath()) + "/audio").normalize();
        this.audioSocket = new SonyAudioClientSocket(this, wsAudioUri, scheduler);
        URI wsSystemUri = this.base_uri.resolve(String.valueOf(this.base_uri.getPath()) + "/system").normalize();
        this.systemSocket = new SonyAudioClientSocket(this, wsSystemUri, scheduler);
    }

    @Override
    public void handleEvent(JsonObject json) {
        JsonObject param;
        int zone = 0;
        try {
            param = json.getAsJsonArray("params").get(0).getAsJsonObject();
        }
        catch (NullPointerException nullPointerException) {
            this.logger.debug("Invalid json in handleEvent");
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.logger.debug("Invalid json in handleEvent");
            return;
        }
        if (param == null) {
            this.logger.debug("Unable to get params form json in handleEvent");
            return;
        }
        if (param.has("output")) {
            String outputStr = param.get("output").getAsString();
            Pattern pattern = Pattern.compile(".*zone=(\\d+)");
            Matcher m = pattern.matcher(outputStr);
            if (m.matches()) {
                try {
                    zone = Integer.parseInt(m.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.error("This should never happen, pattern should only match integers");
                    return;
                }
            }
        }
        if (json.get("method").getAsString().equalsIgnoreCase("notifyPlayingContentInfo")) {
            SonyAudioInput input = new SonyAudioInput();
            input.input = param.get("uri").getAsString();
            if (param.has("broadcastFreq")) {
                int freq = param.get("broadcastFreq").getAsInt();
                input.radio_freq = Optional.of(freq);
                this.checkRadioPreset(input.input);
            }
            this.listener.updateInput(zone, input);
            this.listener.updateSeekStation("");
        }
        if (json.get("method").getAsString().equalsIgnoreCase("notifyVolumeInformation")) {
            SonyAudioVolume volume = new SonyAudioVolume();
            int rawVolume = param.get("volume").getAsInt();
            volume.volume = Math.round(100 * (rawVolume - this.min_volume) / (this.max_volume - this.min_volume));
            volume.mute = param.get("mute").getAsString().equalsIgnoreCase("on");
            this.listener.updateVolume(zone, volume);
        }
        if (json.get("method").getAsString().equalsIgnoreCase("notifyPowerStatus")) {
            String power = param.get("status").getAsString();
            this.listener.updatePowerStatus(zone, power.equalsIgnoreCase("active"));
        }
        this.listener.updateConnectionState(true);
    }

    private void checkRadioPreset(String input) {
        Pattern pattern = Pattern.compile(".*contentId=(\\d+)");
        Matcher m = pattern.matcher(input);
        if (m.matches()) {
            this.listener.updateCurrentRadioStation(Integer.parseInt(m.group(1)));
        }
    }

    @Override
    public synchronized void onConnectionClosed() {
        this.listener.updateConnectionState(false);
    }

    private Notifications getSwitches(SonyAudioClientSocket socket, Notifications notifications) throws IOException {
        SwitchNotifications switchNotifications = new SwitchNotifications(notifications.enabled, notifications.disabled);
        JsonElement switches = socket.callMethod(switchNotifications);
        Type notificationListType = new TypeToken<List<SwitchNotifications.Notification>>(){}.getType();
        notifications.enabled = (List)this.gson.fromJson(switches.getAsJsonArray().get(0).getAsJsonObject().get("enabled"), notificationListType);
        notifications.disabled = (List)this.gson.fromJson(switches.getAsJsonArray().get(0).getAsJsonObject().get("disabled"), notificationListType);
        return notifications;
    }

    @Override
    public synchronized void onConnectionOpened(URI resource) {
        try {
            SwitchNotifications switchNotifications;
            SwitchNotifications.Notification a;
            ListIterator<SwitchNotifications.Notification> iter;
            Notifications notifications = new Notifications();
            notifications.enabled = Arrays.asList(new SwitchNotifications.Notification[0]);
            notifications.disabled = Arrays.asList(new SwitchNotifications.Notification[0]);
            if (this.avContentSocket.getURI().equals(resource)) {
                notifications = this.getSwitches(this.avContentSocket, notifications);
                iter = notifications.disabled.listIterator();
                while (iter.hasNext()) {
                    a = (SwitchNotifications.Notification)iter.next();
                    if (!a.name.equalsIgnoreCase("notifyPlayingContentInfo")) continue;
                    notifications.enabled.add(a);
                    iter.remove();
                }
                switchNotifications = new SwitchNotifications(notifications.enabled, notifications.disabled);
                this.avContentSocket.callMethod(switchNotifications);
            }
            if (this.audioSocket.getURI().equals(resource)) {
                notifications = this.getSwitches(this.audioSocket, notifications);
                iter = notifications.disabled.listIterator();
                while (iter.hasNext()) {
                    a = (SwitchNotifications.Notification)iter.next();
                    if (!a.name.equalsIgnoreCase("notifyVolumeInformation")) continue;
                    notifications.enabled.add(a);
                    iter.remove();
                }
                switchNotifications = new SwitchNotifications(notifications.enabled, notifications.disabled);
                this.audioSocket.callMethod(switchNotifications);
            }
            if (this.systemSocket.getURI().equals(resource)) {
                notifications = this.getSwitches(this.systemSocket, notifications);
                iter = notifications.disabled.listIterator();
                while (iter.hasNext()) {
                    a = (SwitchNotifications.Notification)iter.next();
                    if (!a.name.equalsIgnoreCase("notifyPowerStatus")) continue;
                    notifications.enabled.add(a);
                    iter.remove();
                }
                switchNotifications = new SwitchNotifications(notifications.enabled, notifications.disabled);
                this.systemSocket.callMethod(switchNotifications);
            }
            this.listener.updateConnectionState(true);
        }
        catch (IOException iOException) {
            this.logger.debug("Failed to setup connection");
            this.listener.updateConnectionState(false);
        }
    }

    public synchronized void close() {
        this.logger.debug("SonyAudio closing connections");
        if (this.avContentSocket != null) {
            this.avContentSocket.close();
        }
        this.avContentSocket = null;
        if (this.audioSocket != null) {
            this.audioSocket.close();
        }
        this.audioSocket = null;
        if (this.systemSocket != null) {
            this.systemSocket.close();
        }
        this.systemSocket = null;
    }

    private boolean checkConnection(SonyAudioClientSocket socket) {
        if (!socket.isConnected()) {
            this.logger.debug("checkConnection: try to connect to {}", (Object)socket.getURI().toString());
            socket.open(this.webSocketClient);
            return socket.isConnected();
        }
        return true;
    }

    public boolean checkConnection() {
        return this.checkConnection(this.avContentSocket) && this.checkConnection(this.audioSocket) && this.checkConnection(this.systemSocket);
    }

    public String getConnectionName() {
        if (this.base_uri != null) {
            return this.base_uri.toString();
        }
        return String.format("ws://%s:%d/%s", this.host, this.port, this.path);
    }

    public Boolean getPower(int zone) throws IOException {
        if (zone > 0) {
            if (this.avContentSocket == null) {
                throw new IOException("AvContent Socket not connected");
            }
            GetCurrentExternalTerminalsStatus getCurrentExternalTerminalsStatus = new GetCurrentExternalTerminalsStatus();
            JsonElement element = this.avContentSocket.callMethod(getCurrentExternalTerminalsStatus);
            if (element != null && element.isJsonArray()) {
                Iterator terminals = element.getAsJsonArray().get(0).getAsJsonArray().iterator();
                while (terminals.hasNext()) {
                    JsonObject terminal = ((JsonElement)terminals.next()).getAsJsonObject();
                    String uri = terminal.get("uri").getAsString();
                    if (!uri.equalsIgnoreCase("extOutput:zone?zone=" + Integer.toString(zone))) continue;
                    return terminal.get("active").getAsString().equalsIgnoreCase("active");
                }
            }
            throw new IOException("Unexpected responses: Unable to parse GetCurrentExternalTerminalsStatus response message");
        }
        if (this.systemSocket == null) {
            throw new IOException("System Socket not connected");
        }
        GetPowerStatus getPowerStatus = new GetPowerStatus();
        JsonElement element = this.systemSocket.callMethod(getPowerStatus);
        if (element != null && element.isJsonArray()) {
            String powerStatus = element.getAsJsonArray().get(0).getAsJsonObject().get("status").getAsString();
            return powerStatus.equalsIgnoreCase("active");
        }
        throw new IOException("Unexpected responses: Unable to parse GetPowerStatus response message");
    }

    public void setPower(boolean power) throws IOException {
        this.setPower(power, 0);
    }

    public void setPower(boolean power, int zone) throws IOException {
        if (zone > 0) {
            if (this.avContentSocket == null) {
                throw new IOException("AvContent Socket not connected");
            }
            SetActiveTerminal setActiveTerminal = new SetActiveTerminal(power, zone);
            this.avContentSocket.callMethod(setActiveTerminal);
        } else {
            if (this.systemSocket == null) {
                throw new IOException("System Socket not connected");
            }
            SetPowerStatus setPowerStatus = new SetPowerStatus(power);
            this.systemSocket.callMethod(setPowerStatus);
        }
    }

    public SonyAudioInput getInput() throws IOException {
        GetPlayingContentInfo getPlayingContentInfo = new GetPlayingContentInfo();
        return this.getInput(getPlayingContentInfo);
    }

    public SonyAudioInput getInput(int zone) throws IOException {
        GetPlayingContentInfo getPlayingContentInfo = new GetPlayingContentInfo(zone);
        return this.getInput(getPlayingContentInfo);
    }

    private SonyAudioInput getInput(GetPlayingContentInfo getPlayingContentInfo) throws IOException {
        if (this.avContentSocket == null) {
            throw new IOException("AvContent Socket not connected");
        }
        JsonElement element = this.avContentSocket.callMethod(getPlayingContentInfo);
        if (element != null && element.isJsonArray()) {
            SonyAudioInput ret = new SonyAudioInput();
            JsonObject result = element.getAsJsonArray().get(0).getAsJsonArray().get(0).getAsJsonObject();
            String uri = result.get("uri").getAsString();
            this.checkRadioPreset(uri);
            ret.input = uri;
            if (result.has("broadcastFreq")) {
                int freq = result.get("broadcastFreq").getAsInt();
                ret.radio_freq = Optional.of(freq);
            }
            return ret;
        }
        throw new IOException("Unexpected responses: Unable to parse GetPlayingContentInfo response message");
    }

    public void setInput(String input) throws IOException {
        if (this.avContentSocket == null) {
            throw new IOException("AvContent Socket not connected");
        }
        SetPlayContent setPlayContent = new SetPlayContent(input);
        this.avContentSocket.callMethod(setPlayContent);
    }

    public void setInput(String input, int zone) throws IOException {
        if (this.avContentSocket == null) {
            throw new IOException("AvContent Socket not connected");
        }
        SetPlayContent setPlayContent = new SetPlayContent(input, zone);
        this.avContentSocket.callMethod(setPlayContent);
    }

    public void radioSeekFwd() throws IOException {
        if (this.avContentSocket == null) {
            throw new IOException("AvContent Socket not connected");
        }
        SeekBroadcastStation seekBroadcastStation = new SeekBroadcastStation(true);
        this.avContentSocket.callMethod(seekBroadcastStation);
    }

    public void radioSeekBwd() throws IOException {
        if (this.avContentSocket == null) {
            throw new IOException("AvContent Socket not connected");
        }
        SeekBroadcastStation seekBroadcastStation = new SeekBroadcastStation(false);
        this.avContentSocket.callMethod(seekBroadcastStation);
    }

    public SonyAudioVolume getVolume(int zone) throws IOException {
        GetVolumeInformation getVolumeInformation = new GetVolumeInformation(zone);
        if (this.audioSocket == null || !this.audioSocket.isConnected()) {
            throw new IOException("Audio Socket not connected");
        }
        JsonElement element = this.audioSocket.callMethod(getVolumeInformation);
        if (element != null && element.isJsonArray()) {
            JsonObject result = element.getAsJsonArray().get(0).getAsJsonArray().get(0).getAsJsonObject();
            SonyAudioVolume ret = new SonyAudioVolume();
            int volume = result.get("volume").getAsInt();
            this.min_volume = result.get("minVolume").getAsInt();
            this.max_volume = result.get("maxVolume").getAsInt();
            int vol = Math.round(100 * (volume - this.min_volume) / (this.max_volume - this.min_volume));
            if (vol < 0) {
                vol = 0;
            }
            ret.volume = vol;
            String mute = result.get("mute").getAsString();
            ret.mute = mute.equalsIgnoreCase("on");
            return ret;
        }
        throw new IOException("Unexpected responses: Unable to parse GetVolumeInformation response message");
    }

    public void setVolume(int volume) throws IOException {
        if (this.audioSocket == null) {
            throw new IOException("Audio Socket not connected");
        }
        SetAudioVolume setAudioVolume = new SetAudioVolume(volume, this.min_volume, this.max_volume);
        this.audioSocket.callMethod(setAudioVolume);
    }

    public void setVolume(String volumeChange) throws IOException {
        if (this.audioSocket == null) {
            throw new IOException("Audio Socket not connected");
        }
        SetAudioVolume setAudioVolume = new SetAudioVolume(volumeChange);
        this.audioSocket.callMethod(setAudioVolume);
    }

    public void setVolume(int volume, int zone) throws IOException {
        if (this.audioSocket == null) {
            throw new IOException("Audio Socket not connected");
        }
        SetAudioVolume setAudioVolume = new SetAudioVolume(zone, volume, this.min_volume, this.max_volume);
        this.audioSocket.callMethod(setAudioVolume);
    }

    public void setVolume(String volumeChange, int zone) throws IOException {
        if (this.audioSocket == null) {
            throw new IOException("Audio Socket not connected");
        }
        SetAudioVolume setAudioVolume = new SetAudioVolume(zone, volumeChange);
        this.audioSocket.callMethod(setAudioVolume);
    }

    public void setMute(boolean mute) throws IOException {
        if (this.audioSocket == null) {
            throw new IOException("Audio Socket not connected");
        }
        SetAudioMute setAudioMute = new SetAudioMute(mute);
        this.audioSocket.callMethod(setAudioMute);
    }

    public void setMute(boolean mute, int zone) throws IOException {
        if (this.audioSocket == null) {
            throw new IOException("Audio Socket not connected");
        }
        SetAudioMute setAudioMute = new SetAudioMute(mute, zone);
        this.audioSocket.callMethod(setAudioMute);
    }

    public Map<String, String> getSoundSettings() throws IOException {
        if (this.audioSocket == null) {
            throw new IOException("Audio Socket not connected");
        }
        HashMap<String, String> m = new HashMap<String, String>();
        GetSoundSettings getSoundSettings = new GetSoundSettings();
        JsonElement element = this.audioSocket.callMethod(getSoundSettings);
        if (element == null || !element.isJsonArray()) {
            throw new IOException("Unexpected responses: Unable to parse GetSoundSettings response message");
        }
        Iterator iterator = element.getAsJsonArray().get(0).getAsJsonArray().iterator();
        while (iterator.hasNext()) {
            JsonObject item = ((JsonElement)iterator.next()).getAsJsonObject();
            m.put(item.get("target").getAsString(), item.get("currentValue").getAsString());
        }
        return m;
    }

    public void setSoundSettings(String target, String value) throws IOException {
        if (this.audioSocket == null) {
            throw new IOException("Audio Socket not connected");
        }
        SetSoundSettings setSoundSettings = new SetSoundSettings(target, value);
        this.audioSocket.callMethod(setSoundSettings);
    }

    private class Notifications {
        public List<SwitchNotifications.Notification> enabled;
        public List<SwitchNotifications.Notification> disabled;

        private Notifications() {
        }
    }

    public class SonyAudioInput {
        public String input = "";
        public Optional<Integer> radio_freq = Optional.empty();
    }

    public class SonyAudioVolume {
        public Integer volume = 0;
        public Boolean mute = false;
    }
}

