/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.internal;

import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.PercentType;

public class TradfriColor {
    private static final double[] PRESET_X = new double[]{24933.0, 30138.0, 33137.0};
    private static final double[] PRESET_Y = new double[]{24691.0, 26909.0, 27211.0};
    public Integer xyX;
    public Integer xyY;
    public Integer brightness;

    public TradfriColor(Integer xyX, Integer xyY, Integer brightness) {
        this.xyX = xyX;
        this.xyY = xyY;
        if (brightness != null) {
            this.brightness = brightness > 254 ? Integer.valueOf(254) : brightness;
        }
    }

    public TradfriColor(HSBType hsb) {
        PercentType[] xyArray = hsb.toXY();
        this.xyX = this.normalize(xyArray[0].doubleValue() / 100.0);
        this.xyY = this.normalize(xyArray[1].doubleValue() / 100.0);
        this.brightness = (int)((double)hsb.getBrightness().floatValue() * 2.54);
    }

    public HSBType getHSB() {
        float x = this.unnormalize(this.xyX);
        float y = this.unnormalize(this.xyY);
        HSBType converted = HSBType.fromXY((float)x, (float)y);
        return new HSBType(converted.getHue(), converted.getSaturation(), TradfriColor.xyBrightnessToPercentType(this.brightness));
    }

    public TradfriColor(PercentType percentType) {
        int y;
        int x;
        double percent = percentType.doubleValue();
        if (percent < 50.0) {
            double p = percent / 50.0;
            x = (int)Math.round(PRESET_X[0] + p * (PRESET_X[1] - PRESET_X[0]));
            y = (int)Math.round(PRESET_Y[0] + p * (PRESET_Y[1] - PRESET_Y[0]));
        } else {
            double p = (percent - 50.0) / 50.0;
            x = (int)Math.round(PRESET_X[1] + p * (PRESET_X[2] - PRESET_X[1]));
            y = (int)Math.round(PRESET_Y[1] + p * (PRESET_Y[2] - PRESET_Y[1]));
        }
        this.xyX = x;
        this.xyY = y;
    }

    private int normalize(double value) {
        return (int)(value * 65535.0 + 0.5);
    }

    private float unnormalize(int value) {
        return (float)value / 65535.0f;
    }

    public PercentType getColorTemperature() {
        double x = this.xyX.intValue();
        double y = this.xyY.intValue();
        double value = 0.0;
        if (x > PRESET_X[1] && y > PRESET_Y[1] && x <= PRESET_X[2] && y <= PRESET_Y[2]) {
            value = (x - PRESET_X[1]) / (PRESET_X[2] - PRESET_X[1]) / 2.0 + 0.5;
        } else if (x >= PRESET_X[0] && y >= PRESET_Y[0] && x <= PRESET_X[1] + 2.0 && y <= PRESET_Y[1]) {
            value = (x - PRESET_X[0]) / (PRESET_X[1] - PRESET_X[0]) / 2.0;
        } else if (x < PRESET_X[0]) {
            value = 0.0;
        } else if (x > PRESET_X[2]) {
            value = 1.0;
        }
        return new PercentType((int)Math.round(value * 100.0));
    }

    public static PercentType xyBrightnessToPercentType(int xyBrightness) {
        if (xyBrightness > 254) {
            xyBrightness = 254;
        } else if (xyBrightness < 0) {
            xyBrightness = 0;
        }
        return new PercentType((int)Math.ceil((double)xyBrightness / 2.54));
    }
}

