/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.internal;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.smarthome.binding.tradfri.TradfriBindingConstants;
import org.eclipse.smarthome.binding.tradfri.handler.TradfriControllerHandler;
import org.eclipse.smarthome.binding.tradfri.handler.TradfriGatewayHandler;
import org.eclipse.smarthome.binding.tradfri.handler.TradfriLightHandler;
import org.eclipse.smarthome.binding.tradfri.handler.TradfriPlugHandler;
import org.eclipse.smarthome.binding.tradfri.handler.TradfriSensorHandler;
import org.eclipse.smarthome.binding.tradfri.internal.discovery.TradfriDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;

@Component(service={ThingHandlerFactory.class}, configurationPid="binding.tradfri")
public class TradfriHandlerFactory
extends BaseThingHandlerFactory {
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Stream.of(Stream.of(TradfriBindingConstants.GATEWAY_TYPE_UID), TradfriBindingConstants.SUPPORTED_LIGHT_TYPES_UIDS.stream(), TradfriBindingConstants.SUPPORTED_CONTROLLER_TYPES_UIDS.stream(), TradfriBindingConstants.SUPPORTED_PLUG_TYPES_UIDS.stream()).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toSet());
    private final Map<ThingUID, ServiceRegistration<?>> discoveryServiceRegs = new HashMap();

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (TradfriBindingConstants.GATEWAY_TYPE_UID.equals((Object)thingTypeUID)) {
            TradfriGatewayHandler handler = new TradfriGatewayHandler((Bridge)thing);
            this.registerDiscoveryService(handler);
            return handler;
        }
        if (TradfriBindingConstants.THING_TYPE_DIMMER.equals((Object)thingTypeUID) || TradfriBindingConstants.THING_TYPE_REMOTE_CONTROL.equals((Object)thingTypeUID)) {
            return new TradfriControllerHandler(thing);
        }
        if (TradfriBindingConstants.THING_TYPE_MOTION_SENSOR.equals((Object)thingTypeUID)) {
            return new TradfriSensorHandler(thing);
        }
        if (TradfriBindingConstants.SUPPORTED_LIGHT_TYPES_UIDS.contains(thingTypeUID)) {
            return new TradfriLightHandler(thing);
        }
        if (TradfriBindingConstants.SUPPORTED_PLUG_TYPES_UIDS.contains(thingTypeUID)) {
            return new TradfriPlugHandler(thing);
        }
        return null;
    }

    protected void removeHandler(ThingHandler thingHandler) {
        if (thingHandler instanceof TradfriGatewayHandler) {
            this.unregisterDiscoveryService((TradfriGatewayHandler)thingHandler);
        }
    }

    private synchronized void registerDiscoveryService(TradfriGatewayHandler bridgeHandler) {
        TradfriDiscoveryService discoveryService = new TradfriDiscoveryService(bridgeHandler);
        discoveryService.activate();
        this.discoveryServiceRegs.put(bridgeHandler.getThing().getUID(), this.getBundleContext().registerService(DiscoveryService.class.getName(), (Object)discoveryService, new Hashtable()));
    }

    private synchronized void unregisterDiscoveryService(TradfriGatewayHandler bridgeHandler) {
        ServiceRegistration<?> serviceReg = this.discoveryServiceRegs.remove(bridgeHandler.getThing().getUID());
        if (serviceReg != null) {
            TradfriDiscoveryService service = (TradfriDiscoveryService)this.getBundleContext().getService(serviceReg.getReference());
            serviceReg.unregister();
            if (service != null) {
                service.deactivate();
            }
        }
    }
}

