/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.internal.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import org.eclipse.smarthome.binding.tradfri.internal.TradfriColor;
import org.eclipse.smarthome.binding.tradfri.internal.model.TradfriDeviceData;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradfriLightData
extends TradfriDeviceData {
    private final Logger logger = LoggerFactory.getLogger(TradfriLightData.class);

    public TradfriLightData() {
        super("3311");
    }

    public TradfriLightData(JsonElement json) {
        super("3311", json);
    }

    public TradfriLightData setBrightness(PercentType brightness) {
        this.attributes.add("5851", (JsonElement)new JsonPrimitive((Number)Math.round(brightness.floatValue() / 100.0f * 254.0f)));
        return this;
    }

    public PercentType getBrightness() {
        PercentType result = null;
        JsonElement dimmer = this.attributes.get("5851");
        if (dimmer != null) {
            result = TradfriColor.xyBrightnessToPercentType(dimmer.getAsInt());
        }
        return result;
    }

    public TradfriLightData setTransitionTime(int seconds) {
        this.attributes.add("5712", (JsonElement)new JsonPrimitive((Number)seconds));
        return this;
    }

    public int getTransitionTime() {
        JsonElement transitionTime = this.attributes.get("5712");
        if (transitionTime != null) {
            return transitionTime.getAsInt();
        }
        return 0;
    }

    public TradfriLightData setColorTemperature(PercentType c) {
        TradfriColor color = new TradfriColor(c);
        int x = color.xyX;
        int y = color.xyY;
        this.logger.debug("New color temperature: {},{} ({} %)", new Object[]{x, y, c.intValue()});
        this.attributes.add("5709", (JsonElement)new JsonPrimitive((Number)x));
        this.attributes.add("5710", (JsonElement)new JsonPrimitive((Number)y));
        return this;
    }

    public PercentType getColorTemperature() {
        JsonElement colorX = this.attributes.get("5709");
        JsonElement colorY = this.attributes.get("5710");
        if (colorX != null && colorY != null) {
            TradfriColor color = new TradfriColor(colorX.getAsInt(), colorY.getAsInt(), null);
            return color.getColorTemperature();
        }
        return null;
    }

    public TradfriLightData setColor(HSBType hsb) {
        TradfriColor color = new TradfriColor(hsb);
        this.attributes.add("5709", (JsonElement)new JsonPrimitive((Number)color.xyX));
        this.attributes.add("5710", (JsonElement)new JsonPrimitive((Number)color.xyY));
        return this;
    }

    public HSBType getColor() {
        JsonElement colorX = this.attributes.get("5709");
        JsonElement colorY = this.attributes.get("5710");
        JsonElement dimmer = this.attributes.get("5851");
        if (colorX != null && colorY != null && dimmer != null) {
            int x = colorX.getAsInt();
            int y = colorY.getAsInt();
            int brightness = dimmer.getAsInt();
            TradfriColor color = new TradfriColor(x, y, brightness);
            return color.getHSB();
        }
        return null;
    }

    public TradfriLightData setOnOffState(boolean on) {
        this.attributes.add("5850", (JsonElement)new JsonPrimitive((Number)(on ? 1 : 0)));
        return this;
    }

    public boolean getOnOffState() {
        JsonElement onOff = this.attributes.get("5850");
        if (onOff != null) {
            return onOff.getAsInt() == 1;
        }
        return false;
    }

    public String getJsonString() {
        return this.root.toString();
    }
}

