/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.weatherunderground.internal.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.weatherunderground.WeatherUndergroundBindingConstants;
import org.eclipse.smarthome.binding.weatherunderground.handler.WeatherUndergroundHandler;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.LocationProvider;
import org.eclipse.smarthome.core.library.types.PointType;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherUndergroundDiscoveryService
extends AbstractDiscoveryService {
    private final Logger logger = LoggerFactory.getLogger(WeatherUndergroundDiscoveryService.class);
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(WeatherUndergroundBindingConstants.THING_TYPE_WEATHER);
    private static final int DISCOVER_TIMEOUT_SECONDS = 2;
    private static final int LOCATION_CHANGED_CHECK_INTERVAL = 60;
    private final LocaleProvider localeProvider;
    private final LocationProvider locationProvider;
    private ScheduledFuture<?> discoveryJob;
    private PointType previousLocation;
    private String previousLanguage;
    private String previousCountry;
    private final ThingUID bridgeUID;

    public WeatherUndergroundDiscoveryService(ThingUID bridgeUID, LocaleProvider localeProvider, LocationProvider locationProvider) {
        super(SUPPORTED_THING_TYPES, 2, true);
        this.bridgeUID = bridgeUID;
        this.localeProvider = localeProvider;
        this.locationProvider = locationProvider;
    }

    public void activate(@Nullable Map<@NonNull String, @Nullable Object> configProperties) {
        super.activate(configProperties);
    }

    public void deactivate() {
        super.deactivate();
    }

    protected void startScan() {
        this.logger.debug("Starting Weather Underground discovery scan");
        PointType location = this.locationProvider.getLocation();
        if (location == null) {
            this.logger.debug("LocationProvider.getLocation() is not set -> Will not provide any discovery results");
            return;
        }
        this.createResults(location, this.localeProvider.getLocale());
    }

    protected void startBackgroundDiscovery() {
        this.logger.debug("Starting Weather Underground device background discovery");
        if (this.discoveryJob == null || this.discoveryJob.isCancelled()) {
            this.discoveryJob = this.scheduler.scheduleWithFixedDelay(() -> {
                PointType currentLocation = this.locationProvider.getLocation();
                String currentLanguage = this.localeProvider.getLocale().getLanguage();
                String currentCountry = this.localeProvider.getLocale().getCountry();
                if (currentLocation != null) {
                    boolean update = false;
                    if (!Objects.equals(currentLocation, this.previousLocation)) {
                        this.logger.debug("Location has been changed from {} to {}: Creating new discovery result", (Object)this.previousLocation, (Object)currentLocation);
                        update = true;
                    } else if (!Objects.equals(currentLanguage, this.previousLanguage)) {
                        this.logger.debug("Language has been changed from {} to {}: Creating new discovery result", (Object)this.previousLanguage, (Object)currentLanguage);
                        update = true;
                    } else if (!Objects.equals(currentCountry, this.previousCountry)) {
                        this.logger.debug("Country has been changed from {} to {}: Creating new discovery result", (Object)this.previousCountry, (Object)currentCountry);
                        update = true;
                    }
                    if (update) {
                        this.createResults(currentLocation, this.localeProvider.getLocale());
                        this.previousLocation = currentLocation;
                        this.previousLanguage = currentLanguage;
                        this.previousCountry = currentCountry;
                    }
                }
            }, 0L, 60L, TimeUnit.SECONDS);
            this.logger.debug("Scheduled Weather Underground location-changed job every {} seconds", (Object)60);
        }
    }

    protected void stopBackgroundDiscovery() {
        this.logger.debug("Stopping Weather Underground device background discovery");
        if (this.discoveryJob != null && !this.discoveryJob.isCancelled()) {
            this.discoveryJob.cancel(true);
            this.discoveryJob = null;
            this.logger.debug("Stopped Weather Underground device background discovery");
        }
    }

    private void createResults(PointType location, Locale locale) {
        ThingUID localWeatherThing = new ThingUID(WeatherUndergroundBindingConstants.THING_TYPE_WEATHER, "local");
        HashMap<String, String> properties = new HashMap<String, String>(3);
        properties.put("location", String.format("%s,%s", location.getLatitude(), location.getLongitude()));
        String lang = WeatherUndergroundHandler.getCodeFromLanguage(locale);
        if (!lang.isEmpty()) {
            properties.put("language", lang);
        }
        this.thingDiscovered(DiscoveryResultBuilder.create((ThingUID)localWeatherThing).withLabel("Local Weather").withProperties(properties).withBridge(this.bridgeUID).build());
    }
}

