/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.weatherunderground.internal.json;

import java.math.BigDecimal;
import java.net.URL;
import java.time.ZonedDateTime;
import org.eclipse.smarthome.binding.weatherunderground.internal.json.WeatherUndergroundJsonUtils;

public class WeatherUndergroundJsonForecastDay {
    private ForecastDate date;
    private Integer period;
    private ForecastTemperature high;
    private ForecastTemperature low;
    private String conditions;
    private String icon;
    private String icon_url;
    private Integer pop;
    private ForecastPrecipitation qpf_allday;
    private ForecastPrecipitation snow_allday;
    private ForecastWind maxwind;
    private ForecastWind avewind;
    private Integer avehumidity;

    public ZonedDateTime getForecastTime() {
        return WeatherUndergroundJsonUtils.convertToZonedDateTime(this.date == null ? null : this.date.getEpoch());
    }

    public Integer getPeriod() {
        return this.period;
    }

    public String getConditions() {
        return this.conditions;
    }

    public URL getIcon() {
        return WeatherUndergroundJsonUtils.getValidUrl(this.icon_url);
    }

    public String getIconKey() {
        return this.icon;
    }

    public BigDecimal getMinTemperatureC() {
        return this.low == null ? null : WeatherUndergroundJsonUtils.convertToBigDecimal(this.low.getCelsius());
    }

    public BigDecimal getMinTemperatureF() {
        return this.low == null ? null : WeatherUndergroundJsonUtils.convertToBigDecimal(this.low.getFahrenheit());
    }

    public BigDecimal getMaxTemperatureC() {
        return this.high == null ? null : WeatherUndergroundJsonUtils.convertToBigDecimal(this.high.getCelsius());
    }

    public BigDecimal getMaxTemperatureF() {
        return this.high == null ? null : WeatherUndergroundJsonUtils.convertToBigDecimal(this.high.getFahrenheit());
    }

    public Integer getRelativeHumidity() {
        return this.avehumidity;
    }

    public Integer getProbaPrecipitation() {
        return this.pop;
    }

    public BigDecimal getPrecipitationDayMm() {
        return this.qpf_allday == null ? null : this.qpf_allday.mm;
    }

    public BigDecimal getPrecipitationDayIn() {
        return this.qpf_allday == null ? null : this.qpf_allday.in;
    }

    public BigDecimal getSnowCm() {
        return this.snow_allday == null ? null : this.snow_allday.cm;
    }

    public BigDecimal getSnowIn() {
        return this.snow_allday == null ? null : this.snow_allday.in;
    }

    public String getMaxWindDirection() {
        return this.maxwind == null ? null : this.maxwind.getDir();
    }

    public BigDecimal getMaxWindDirectionDegrees() {
        return this.maxwind == null ? null : WeatherUndergroundJsonUtils.convertToBigDecimal(this.maxwind.getDegrees());
    }

    public BigDecimal getMaxWindSpeedKmh() {
        return this.maxwind == null ? null : this.maxwind.getKph();
    }

    public BigDecimal getMaxWindSpeedMph() {
        return this.maxwind == null ? null : this.maxwind.getMph();
    }

    public String getAverageWindDirection() {
        return this.avewind == null ? null : this.avewind.getDir();
    }

    public BigDecimal getAverageWindDirectionDegrees() {
        return this.avewind == null ? null : WeatherUndergroundJsonUtils.convertToBigDecimal(this.avewind.getDegrees());
    }

    public BigDecimal getAverageWindSpeedKmh() {
        return this.avewind == null ? null : this.avewind.getKph();
    }

    public BigDecimal getAverageWindSpeedMph() {
        return this.avewind == null ? null : this.avewind.getMph();
    }

    class ForecastDate {
        private String epoch;

        ForecastDate() {
        }

        public String getEpoch() {
            return this.epoch;
        }
    }

    class ForecastPrecipitation {
        private BigDecimal in;
        private BigDecimal mm;
        private BigDecimal cm;

        ForecastPrecipitation() {
        }

        public BigDecimal getIn() {
            return this.in;
        }

        public BigDecimal getMm() {
            return this.mm;
        }

        public BigDecimal getCm() {
            return this.cm;
        }
    }

    class ForecastTemperature {
        private String fahrenheit;
        private String celsius;

        ForecastTemperature() {
        }

        public String getFahrenheit() {
            return this.fahrenheit;
        }

        public String getCelsius() {
            return this.celsius;
        }
    }

    class ForecastWind {
        private BigDecimal mph;
        private BigDecimal kph;
        private String dir;
        private String degrees;

        ForecastWind() {
        }

        public BigDecimal getMph() {
            return this.mph;
        }

        public BigDecimal getKph() {
            return this.kph;
        }

        public String getDir() {
            return this.dir;
        }

        public String getDegrees() {
            return this.degrees;
        }
    }
}

