/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.internal.normalization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.internal.normalization.AbstractNormalizer;
import org.eclipse.smarthome.config.core.internal.normalization.BooleanNormalizer;
import org.eclipse.smarthome.config.core.internal.normalization.DecimalNormalizer;
import org.eclipse.smarthome.config.core.internal.normalization.IntNormalizer;
import org.eclipse.smarthome.config.core.internal.normalization.ListNormalizer;
import org.eclipse.smarthome.config.core.internal.normalization.Normalizer;
import org.eclipse.smarthome.config.core.internal.normalization.TextNormalizer;

public final class NormalizerFactory {
    private static final Map<ConfigDescriptionParameter.Type, Normalizer> NORMALIZERS;

    static {
        HashMap<ConfigDescriptionParameter.Type, AbstractNormalizer> map = new HashMap<ConfigDescriptionParameter.Type, AbstractNormalizer>(11);
        map.put(ConfigDescriptionParameter.Type.BOOLEAN, new BooleanNormalizer());
        map.put(ConfigDescriptionParameter.Type.TEXT, new TextNormalizer());
        map.put(ConfigDescriptionParameter.Type.INTEGER, new IntNormalizer());
        map.put(ConfigDescriptionParameter.Type.DECIMAL, new DecimalNormalizer());
        NORMALIZERS = Collections.unmodifiableMap(map);
    }

    private NormalizerFactory() {
    }

    public static Normalizer getNormalizer(ConfigDescriptionParameter configDescriptionParameter) {
        if (configDescriptionParameter == null) {
            throw new IllegalArgumentException("The config description parameter must not be null.");
        }
        Normalizer ret = NORMALIZERS.get((Object)configDescriptionParameter.getType());
        if (configDescriptionParameter.isMultiple().booleanValue()) {
            ret = new ListNormalizer(ret);
        }
        return ret;
    }
}

