/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.status;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.smarthome.config.core.status.ConfigStatusMessage;

public final class ConfigStatusInfo {
    private final Collection<ConfigStatusMessage> configStatusMessages = new ArrayList<ConfigStatusMessage>();

    public ConfigStatusInfo() {
    }

    public ConfigStatusInfo(Collection<ConfigStatusMessage> configStatusMessages) {
        this.add(configStatusMessages);
    }

    public Collection<ConfigStatusMessage> getConfigStatusMessages() {
        return Collections.unmodifiableCollection(this.configStatusMessages);
    }

    public Collection<ConfigStatusMessage> getConfigStatusMessages(ConfigStatusMessage.Type ... types) {
        List<ConfigStatusMessage.Type> typesCollection = Arrays.asList(types);
        return this.filter(typesCollection, configStatusMessage -> typesCollection.contains((Object)configStatusMessage.type));
    }

    public Collection<ConfigStatusMessage> getConfigStatusMessages(String ... parameterNames) {
        List<String> parameterNamesCollection = Arrays.asList(parameterNames);
        return this.filter(parameterNamesCollection, configStatusMessage -> parameterNamesCollection.contains(configStatusMessage.parameterName));
    }

    public Collection<ConfigStatusMessage> getConfigStatusMessages(Collection<ConfigStatusMessage.Type> types, Collection<String> parameterNames) {
        Objects.requireNonNull(types);
        Objects.requireNonNull(parameterNames);
        return ConfigStatusInfo.filterConfigStatusMessages(this.getConfigStatusMessages(), configStatusMessage -> types.contains((Object)configStatusMessage.type) || parameterNames.contains(configStatusMessage.parameterName));
    }

    public void add(ConfigStatusMessage configStatusMessage) {
        if (configStatusMessage == null) {
            throw new IllegalArgumentException("Config status message must not be null");
        }
        this.configStatusMessages.add(configStatusMessage);
    }

    public void add(Collection<ConfigStatusMessage> configStatusMessages) {
        if (configStatusMessages == null) {
            throw new IllegalArgumentException("Config status messages must not be null");
        }
        for (ConfigStatusMessage configStatusMessage : configStatusMessages) {
            this.add(configStatusMessage);
        }
    }

    private Collection<ConfigStatusMessage> filter(Collection<?> filter, Predicate<ConfigStatusMessage> predicate) {
        if (filter.isEmpty()) {
            return this.getConfigStatusMessages();
        }
        return ConfigStatusInfo.filterConfigStatusMessages(this.getConfigStatusMessages(), predicate);
    }

    private static Collection<ConfigStatusMessage> filterConfigStatusMessages(Collection<ConfigStatusMessage> configStatusMessages, Predicate<? super ConfigStatusMessage> predicate) {
        return configStatusMessages.stream().filter(predicate).collect(Collectors.toList());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.configStatusMessages == null ? 0 : this.configStatusMessages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigStatusInfo other = (ConfigStatusInfo)obj;
        return !(this.configStatusMessages == null ? other.configStatusMessages != null : !this.configStatusMessages.equals(other.configStatusMessages));
    }

    public String toString() {
        return "ConfigStatusInfo [configStatusMessages=" + this.configStatusMessages + "]";
    }
}

