/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.inbox.events;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.dto.DiscoveryResultDTO;
import org.eclipse.smarthome.config.discovery.dto.DiscoveryResultDTOMapper;
import org.eclipse.smarthome.config.discovery.inbox.events.InboxAddedEvent;
import org.eclipse.smarthome.config.discovery.inbox.events.InboxRemovedEvent;
import org.eclipse.smarthome.config.discovery.inbox.events.InboxUpdatedEvent;
import org.eclipse.smarthome.core.events.AbstractEventFactory;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFactory;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={EventFactory.class})
public class InboxEventFactory
extends AbstractEventFactory {
    static final String INBOX_ADDED_EVENT_TOPIC = "smarthome/inbox/{thingUID}/added";
    static final String INBOX_REMOVED_EVENT_TOPIC = "smarthome/inbox/{thingUID}/removed";
    static final String INBOX_UPDATED_EVENT_TOPIC = "smarthome/inbox/{thingUID}/updated";

    public InboxEventFactory() {
        super(Stream.of(InboxAddedEvent.TYPE, InboxUpdatedEvent.TYPE, InboxRemovedEvent.TYPE).collect(Collectors.toSet()));
    }

    protected Event createEventByType(String eventType, String topic, String payload, String source) throws Exception {
        Event event = null;
        if (eventType.equals(InboxAddedEvent.TYPE)) {
            event = this.createAddedEvent(topic, payload);
        } else if (eventType.equals(InboxRemovedEvent.TYPE)) {
            event = this.createRemovedEvent(topic, payload);
        } else if (eventType.equals(InboxUpdatedEvent.TYPE)) {
            event = this.createUpdatedEvent(topic, payload);
        }
        return event;
    }

    private Event createAddedEvent(String topic, String payload) {
        DiscoveryResultDTO resultDTO = (DiscoveryResultDTO)InboxEventFactory.deserializePayload((String)payload, DiscoveryResultDTO.class);
        return new InboxAddedEvent(topic, payload, resultDTO);
    }

    private Event createRemovedEvent(String topic, String payload) {
        DiscoveryResultDTO resultDTO = (DiscoveryResultDTO)InboxEventFactory.deserializePayload((String)payload, DiscoveryResultDTO.class);
        return new InboxRemovedEvent(topic, payload, resultDTO);
    }

    private Event createUpdatedEvent(String topic, String payload) {
        DiscoveryResultDTO resultDTO = (DiscoveryResultDTO)InboxEventFactory.deserializePayload((String)payload, DiscoveryResultDTO.class);
        return new InboxUpdatedEvent(topic, payload, resultDTO);
    }

    public static InboxAddedEvent createAddedEvent(DiscoveryResult discoveryResult) {
        InboxEventFactory.assertValidArgument(discoveryResult);
        String topic = InboxEventFactory.buildTopic(INBOX_ADDED_EVENT_TOPIC, discoveryResult.getThingUID().getAsString());
        DiscoveryResultDTO resultDTO = InboxEventFactory.map(discoveryResult);
        String payload = InboxEventFactory.serializePayload((Object)resultDTO);
        return new InboxAddedEvent(topic, payload, resultDTO);
    }

    public static InboxRemovedEvent createRemovedEvent(DiscoveryResult discoveryResult) {
        InboxEventFactory.assertValidArgument(discoveryResult);
        String topic = InboxEventFactory.buildTopic(INBOX_REMOVED_EVENT_TOPIC, discoveryResult.getThingUID().getAsString());
        DiscoveryResultDTO resultDTO = InboxEventFactory.map(discoveryResult);
        String payload = InboxEventFactory.serializePayload((Object)resultDTO);
        return new InboxRemovedEvent(topic, payload, resultDTO);
    }

    public static InboxUpdatedEvent createUpdatedEvent(DiscoveryResult discoveryResult) {
        InboxEventFactory.assertValidArgument(discoveryResult);
        String topic = InboxEventFactory.buildTopic(INBOX_UPDATED_EVENT_TOPIC, discoveryResult.getThingUID().getAsString());
        DiscoveryResultDTO resultDTO = InboxEventFactory.map(discoveryResult);
        String payload = InboxEventFactory.serializePayload((Object)resultDTO);
        return new InboxUpdatedEvent(topic, payload, resultDTO);
    }

    private static void assertValidArgument(DiscoveryResult discoveryResult) {
        InboxEventFactory.checkNotNull((Object)discoveryResult, (String)"discoveryResult");
    }

    private static String buildTopic(String topic, String thingUID) {
        return topic.replace("{thingUID}", thingUID);
    }

    private static DiscoveryResultDTO map(DiscoveryResult discoveryResult) {
        return DiscoveryResultDTOMapper.map(discoveryResult);
    }
}

