/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal.console;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultFlag;
import org.eclipse.smarthome.config.discovery.inbox.Inbox;
import org.eclipse.smarthome.config.discovery.inbox.InboxPredicates;
import org.eclipse.smarthome.config.discovery.internal.PersistentInbox;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ConsoleCommandExtension.class})
public class InboxConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_APPROVE = "approve";
    private static final String SUBCMD_IGNORE = "ignore";
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_LIST_IGNORED = "listignored";
    private static final String SUBCMD_CLEAR = "clear";
    private static final String SUBCMD_REMOVE = "remove";
    private Inbox inbox;

    public InboxConsoleCommandExtension() {
        super("inbox", "Manage your inbox.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(String[] args, Console console) {
        block37: {
            String subCommand;
            if (args.length <= 0) break block37;
            switch (subCommand = args[0]) {
                case "approve": {
                    if (args.length > 2) {
                        String label = args[2];
                        try {
                            ThingUID thingUID = new ThingUID(args[1]);
                            List results = this.inbox.stream().filter(InboxPredicates.forThingUID(thingUID)).collect(Collectors.toList());
                            if (results.isEmpty()) {
                                console.println("No matching inbox entry could be found.");
                                return;
                            }
                            this.inbox.approve(thingUID, label);
                            return;
                        }
                        catch (IllegalArgumentException e) {
                            console.println(e.getMessage());
                        }
                        return;
                    }
                    console.println("Specify thing id to approve: inbox approve <thingUID> <label>");
                    return;
                }
                case "ignore": {
                    if (args.length > 1) {
                        try {
                            ThingUID thingUID = new ThingUID(args[1]);
                            PersistentInbox persistentInbox = (PersistentInbox)this.inbox;
                            persistentInbox.setFlag(thingUID, DiscoveryResultFlag.IGNORED);
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            console.println("'" + args[1] + "' is no valid thing UID.");
                        }
                        return;
                    }
                    console.println("Cannot approve thing as managed thing provider is missing.");
                    return;
                }
                case "list": {
                    this.printInboxEntries(console, this.inbox.stream().filter(InboxPredicates.withFlag(DiscoveryResultFlag.NEW)).collect(Collectors.toList()));
                    return;
                }
                case "listignored": {
                    this.printInboxEntries(console, this.inbox.stream().filter(InboxPredicates.withFlag(DiscoveryResultFlag.IGNORED)).collect(Collectors.toList()));
                    return;
                }
                case "clear": {
                    this.clearInboxEntries(console, this.inbox.getAll());
                    return;
                }
                case "remove": {
                    if (args.length > 1) {
                        List<DiscoveryResult> results;
                        boolean validParam = true;
                        try {
                            ThingUID thingUID = new ThingUID(args[1]);
                            results = this.inbox.stream().filter(InboxPredicates.forThingUID(thingUID)).collect(Collectors.toList());
                            if (results.isEmpty()) {
                                console.println("No matching inbox entry could be found.");
                            } else {
                                this.clearInboxEntries(console, results);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            validParam = false;
                        }
                        if (validParam) return;
                        try {
                            ThingTypeUID thingTypeUID = new ThingTypeUID(args[1]);
                            results = this.inbox.stream().filter(InboxPredicates.forThingTypeUID(thingTypeUID)).collect(Collectors.toList());
                            if (results.isEmpty()) {
                                console.println("No matching inbox entry could be found.");
                                return;
                            }
                            this.clearInboxEntries(console, results);
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            console.println("'" + args[1] + "' is no valid thing UID or thing type.");
                        }
                        return;
                    }
                    console.println("Specify thing id or thing type to remove: inbox remove [<thingUID>|<thingTypeUID>]");
                    return;
                }
                default: {
                    this.printUsage(console);
                    return;
                }
            }
        }
        this.printUsage(console);
    }

    private void printInboxEntries(Console console, List<DiscoveryResult> discoveryResults) {
        if (discoveryResults.isEmpty()) {
            console.println("No inbox entries found.");
        }
        for (DiscoveryResult discoveryResult : discoveryResults) {
            ThingTypeUID thingTypeUID = discoveryResult.getThingTypeUID();
            ThingUID thingUID = discoveryResult.getThingUID();
            String label = discoveryResult.getLabel();
            DiscoveryResultFlag flag = discoveryResult.getFlag();
            ThingUID bridgeId = discoveryResult.getBridgeUID();
            Map<String, Object> properties = discoveryResult.getProperties();
            String representationProperty = discoveryResult.getRepresentationProperty();
            String timestamp = new Date(discoveryResult.getTimestamp()).toString();
            String timeToLive = discoveryResult.getTimeToLive() == -1L ? "UNLIMITED" : "" + discoveryResult.getTimeToLive();
            console.println(String.format("%s [%s]: %s [thingId=%s, bridgeId=%s, properties=%s, representationProperty=%s, timestamp=%s, timeToLive=%s]", flag.name(), thingTypeUID, label, thingUID, bridgeId, properties, representationProperty, timestamp, timeToLive));
        }
    }

    private void clearInboxEntries(Console console, List<DiscoveryResult> discoveryResults) {
        if (discoveryResults.isEmpty()) {
            console.println("No inbox entries found.");
        }
        for (DiscoveryResult discoveryResult : discoveryResults) {
            ThingTypeUID thingTypeUID = discoveryResult.getThingTypeUID();
            ThingUID thingUID = discoveryResult.getThingUID();
            String label = discoveryResult.getLabel();
            DiscoveryResultFlag flag = discoveryResult.getFlag();
            ThingUID bridgeId = discoveryResult.getBridgeUID();
            Map<String, Object> properties = discoveryResult.getProperties();
            console.println(String.format("REMOVED [%s]: %s [label=%s, thingId=%s, bridgeId=%s, properties=%s]", flag.name(), thingTypeUID, label, thingUID, bridgeId, properties));
            this.inbox.remove(thingUID);
        }
    }

    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage(SUBCMD_LIST, "lists all current inbox entries"), this.buildCommandUsage(SUBCMD_LIST_IGNORED, "lists all ignored inbox entries"), this.buildCommandUsage("approve <thingUID> <label>", "creates a thing for an inbox entry"), this.buildCommandUsage(SUBCMD_CLEAR, "clears all current inbox entries"), this.buildCommandUsage("remove [<thingUID>|<thingTypeUID>]", "remove the inbox entries of a given thing id or thing type"), this.buildCommandUsage("ignore <thingUID>", "ignores an inbox entry permanently"));
    }

    @Reference
    protected void setInbox(Inbox inbox) {
        this.inbox = inbox;
    }

    protected void unsetInbox(Inbox inbox) {
        this.inbox = null;
    }
}

