/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.eclipse.smarthome.config.xml.util.GenericUnmarshaller;
import org.eclipse.smarthome.config.xml.util.NodeIterator;
import org.eclipse.smarthome.config.xml.util.NodeList;
import org.eclipse.smarthome.config.xml.util.NodeValue;
import org.eclipse.smarthome.core.types.CommandDescription;
import org.eclipse.smarthome.core.types.CommandDescriptionBuilder;
import org.eclipse.smarthome.core.types.CommandOption;

public class CommandDescriptionConverter
extends GenericUnmarshaller<CommandDescription> {
    public CommandDescriptionConverter() {
        super(CommandDescription.class);
    }

    public final CommandDescription unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        NodeList nodes = (NodeList)context.convertAnother((Object)context, NodeList.class);
        NodeIterator nodeIterator = new NodeIterator(nodes.getList());
        NodeList commandOptionsNode = (NodeList)nodeIterator.next();
        if (commandOptionsNode != null && "options".equals(commandOptionsNode.getNodeName())) {
            CommandDescriptionBuilder commandDescriptionBuilder = CommandDescriptionBuilder.create();
            for (Object coNodeObject : commandOptionsNode.getList()) {
                NodeValue optionsNode = (NodeValue)coNodeObject;
                if ("option".equals(optionsNode.getNodeName())) {
                    String name = (String)optionsNode.getValue();
                    String command = (String)optionsNode.getAttributes().get("value");
                    if (name == null || command == null) continue;
                    commandDescriptionBuilder.withCommandOption(new CommandOption(command, name));
                    continue;
                }
                throw new ConversionException("The 'options' node must only contain 'option' nodes!");
            }
            nodeIterator.assertEndOfType();
            return commandDescriptionBuilder.build();
        }
        nodeIterator.assertEndOfType();
        return null;
    }
}

