/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.i18n;

import java.util.Locale;
import org.eclipse.smarthome.core.i18n.I18nUtil;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;

public class BindingI18nUtil {
    private final TranslationProvider i18nProvider;

    public BindingI18nUtil(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    public String getDescription(Bundle bundle, String bindingId, String defaultDescription, Locale locale) {
        String key = I18nUtil.stripConstantOr(defaultDescription, () -> this.inferKey(bindingId, "description"));
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    public String getName(Bundle bundle, String bindingId, String defaultLabel, Locale locale) {
        String key = I18nUtil.stripConstantOr(defaultLabel, () -> this.inferKey(bindingId, "name"));
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    private String inferKey(String bindingId, String lastSegment) {
        return "binding." + bindingId + "." + lastSegment;
    }
}

