/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.service;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.service.CommandDescriptionService;
import org.eclipse.smarthome.core.types.CommandDescription;
import org.eclipse.smarthome.core.types.CommandDescriptionProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component
public class CommandDescriptionServiceImpl
implements CommandDescriptionService {
    private final List<CommandDescriptionProvider> commandDescriptionProviders = new CopyOnWriteArrayList<CommandDescriptionProvider>();

    @Override
    public @Nullable CommandDescription getCommandDescription(String itemName, @Nullable Locale locale) {
        for (CommandDescriptionProvider cdp : this.commandDescriptionProviders) {
            CommandDescription commandDescription = cdp.getCommandDescription(itemName, locale);
            if (commandDescription == null) continue;
            return commandDescription;
        }
        return null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addCommandDescriptionProvider(CommandDescriptionProvider commandDescriptionProvider) {
        this.commandDescriptionProviders.add(commandDescriptionProvider);
    }

    protected void removeCommandDescriptionProvider(CommandDescriptionProvider commandDescriptionProvider) {
        this.commandDescriptionProviders.remove(commandDescriptionProvider);
    }
}

