/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public interface ArithmeticGroupFunction
extends GroupFunction {

    public static class And
    implements GroupFunction {
        protected final State activeState;
        protected final State passiveState;

        public And(State activeValue, State passiveValue) {
            if (activeValue == null || passiveValue == null) {
                throw new IllegalArgumentException("Parameters must not be null!");
            }
            this.activeState = activeValue;
            this.passiveState = passiveValue;
        }

        @Override
        public State calculate(Set<Item> items) {
            if (items != null && items.size() > 0) {
                for (Item item : items) {
                    if (this.activeState.equals(item.getStateAs(this.activeState.getClass()))) continue;
                    return this.passiveState;
                }
                return this.activeState;
            }
            return this.passiveState;
        }

        @Override
        public <T extends State> T getStateAs(Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            if (stateClass == DecimalType.class) {
                if (items != null) {
                    return (T)((State)stateClass.cast(new DecimalType(items.size() - this.count(items, this.activeState))));
                }
                return (T)((State)stateClass.cast(DecimalType.ZERO));
            }
            return null;
        }

        private int count(Set<Item> items, State state) {
            int count = 0;
            if (items != null && state != null) {
                for (Item item : items) {
                    if (!state.equals(item.getStateAs(state.getClass()))) continue;
                    ++count;
                }
            }
            return count;
        }

        @Override
        public State[] getParameters() {
            return new State[]{this.activeState, this.passiveState};
        }
    }

    public static class Avg
    implements GroupFunction {
        @Override
        public State calculate(Set<Item> items) {
            BigDecimal sum = BigDecimal.ZERO;
            int count = 0;
            if (items != null) {
                for (Item item : items) {
                    DecimalType itemState = item.getStateAs(DecimalType.class);
                    if (itemState == null) continue;
                    sum = sum.add(itemState.toBigDecimal());
                    ++count;
                }
            }
            if (count > 0) {
                return new DecimalType(sum.divide(BigDecimal.valueOf(count), RoundingMode.HALF_UP));
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> T getStateAs(Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }

    public static class Count
    implements GroupFunction {
        protected final Pattern pattern;

        public Count(State regExpr) {
            if (regExpr == null) {
                throw new IllegalArgumentException("Parameter must not be null!");
            }
            this.pattern = Pattern.compile(regExpr.toString());
        }

        @Override
        public State calculate(Set<Item> items) {
            int count = 0;
            if (items != null) {
                for (Item item : items) {
                    Matcher matcher = this.pattern.matcher(item.getState().toString());
                    if (!matcher.matches()) continue;
                    ++count;
                }
            }
            return new DecimalType(count);
        }

        @Override
        public <T extends State> T getStateAs(Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[]{new StringType(this.pattern.pattern())};
        }
    }

    public static class Max
    implements GroupFunction {
        @Override
        public State calculate(Set<Item> items) {
            if (items != null && items.size() > 0) {
                BigDecimal max = null;
                for (Item item : items) {
                    DecimalType itemState = item.getStateAs(DecimalType.class);
                    if (itemState == null || max != null && max.compareTo(itemState.toBigDecimal()) >= 0) continue;
                    max = itemState.toBigDecimal();
                }
                if (max != null) {
                    return new DecimalType(max);
                }
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> T getStateAs(Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }

    public static class Min
    implements GroupFunction {
        @Override
        public State calculate(Set<Item> items) {
            if (items != null && items.size() > 0) {
                BigDecimal min = null;
                for (Item item : items) {
                    DecimalType itemState = item.getStateAs(DecimalType.class);
                    if (itemState == null || min != null && min.compareTo(itemState.toBigDecimal()) <= 0) continue;
                    min = itemState.toBigDecimal();
                }
                if (min != null) {
                    return new DecimalType(min);
                }
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> T getStateAs(Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }

    public static class NAnd
    extends And {
        public NAnd(State activeValue, State passiveValue) {
            super(activeValue, passiveValue);
        }

        @Override
        public State calculate(Set<Item> items) {
            State result = super.calculate(items);
            State notResult = result.equals(this.activeState) ? this.passiveState : this.activeState;
            return notResult;
        }
    }

    public static class NOr
    extends Or {
        public NOr(State activeValue, State passiveValue) {
            super(activeValue, passiveValue);
        }

        @Override
        public State calculate(Set<Item> items) {
            State result = super.calculate(items);
            State notResult = result.equals(this.activeState) ? this.passiveState : this.activeState;
            return notResult;
        }
    }

    public static class Or
    implements GroupFunction {
        protected final State activeState;
        protected final State passiveState;

        public Or(State activeValue, State passiveValue) {
            if (activeValue == null || passiveValue == null) {
                throw new IllegalArgumentException("Parameters must not be null!");
            }
            this.activeState = activeValue;
            this.passiveState = passiveValue;
        }

        @Override
        public State calculate(Set<Item> items) {
            if (items != null) {
                for (Item item : items) {
                    if (!this.activeState.equals(item.getStateAs(this.activeState.getClass()))) continue;
                    return this.activeState;
                }
            }
            return this.passiveState;
        }

        @Override
        public <T extends State> T getStateAs(Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            if (stateClass == DecimalType.class) {
                return (T)((State)stateClass.cast(new DecimalType(this.count(items, this.activeState))));
            }
            return null;
        }

        private int count(Set<Item> items, State state) {
            int count = 0;
            if (items != null && state != null) {
                for (Item item : items) {
                    if (!state.equals(item.getStateAs(state.getClass()))) continue;
                    ++count;
                }
            }
            return count;
        }

        @Override
        public State[] getParameters() {
            return new State[]{this.activeState, this.passiveState};
        }
    }

    public static class Sum
    implements GroupFunction {
        @Override
        public State calculate(Set<Item> items) {
            BigDecimal sum = BigDecimal.ZERO;
            if (items != null) {
                for (Item item : items) {
                    DecimalType itemState = item.getStateAs(DecimalType.class);
                    if (itemState == null) continue;
                    sum = sum.add(itemState.toBigDecimal());
                }
            }
            return new DecimalType(sum);
        }

        @Override
        public <T extends State> T getStateAs(Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }
}

