/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mdns.internal;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import org.eclipse.smarthome.io.transport.mdns.MDNSClient;
import org.eclipse.smarthome.io.transport.mdns.MDNSService;
import org.eclipse.smarthome.io.transport.mdns.ServiceDescription;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class MDNSServiceImpl
implements MDNSService {
    private final Logger logger = LoggerFactory.getLogger(MDNSServiceImpl.class);
    private MDNSClient mdnsClient;
    private final Set<ServiceDescription> servicesToRegisterQueue = new CopyOnWriteArraySet<ServiceDescription>();

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setMDNSClient(MDNSClient client) {
        this.mdnsClient = client;
        if (this.servicesToRegisterQueue.size() > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MDNSServiceImpl.this.logger.debug("Registering {} queued services", (Object)MDNSServiceImpl.this.servicesToRegisterQueue.size());
                    for (ServiceDescription description : MDNSServiceImpl.this.servicesToRegisterQueue) {
                        try {
                            MDNSClient localClient = MDNSServiceImpl.this.mdnsClient;
                            if (localClient == null) break;
                            localClient.registerService(description);
                        }
                        catch (IOException e) {
                            MDNSServiceImpl.this.logger.error("{}", (Object)e.getMessage());
                        }
                        catch (IllegalStateException illegalStateException) {
                            MDNSServiceImpl.this.logger.debug("Not registering service {}, because service is already deactivated!", (Object)description.serviceType);
                        }
                    }
                    MDNSServiceImpl.this.servicesToRegisterQueue.clear();
                }
            };
            Executors.newSingleThreadExecutor().execute(runnable);
        }
    }

    protected void unsetMDNSClient(MDNSClient mdnsClient) {
        this.mdnsClient = null;
        mdnsClient.unregisterAllServices();
    }

    @Override
    public void registerService(final ServiceDescription description) {
        if (this.mdnsClient == null) {
            this.servicesToRegisterQueue.add(description);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        MDNSServiceImpl.this.mdnsClient.registerService(description);
                    }
                    catch (IOException e) {
                        MDNSServiceImpl.this.logger.error("{}", (Object)e.getMessage());
                    }
                    catch (IllegalStateException illegalStateException) {
                        MDNSServiceImpl.this.logger.debug("Not registering service {}, because service is already deactivated!", (Object)description.serviceType);
                    }
                }
            };
            Executors.newSingleThreadExecutor().execute(runnable);
        }
    }

    @Override
    public void unregisterService(ServiceDescription description) {
        if (this.mdnsClient != null) {
            this.mdnsClient.unregisterService(description);
        }
    }

    protected void unregisterAllServices() {
        if (this.mdnsClient != null) {
            this.mdnsClient.unregisterAllServices();
        }
    }

    @Activate
    public void activate() {
    }

    @Deactivate
    public void deactivate() {
        this.unregisterAllServices();
        if (this.mdnsClient != null) {
            this.mdnsClient.close();
            this.logger.debug("mDNS service has been stopped");
        }
    }
}

