/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mqtt.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionObserver;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionState;
import org.eclipse.smarthome.io.transport.mqtt.MqttException;
import org.eclipse.smarthome.io.transport.mqtt.internal.TopicSubscribers;
import org.eclipse.smarthome.io.transport.mqtt.reconnect.AbstractReconnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCallback
implements MqttCallback {
    final Logger logger = LoggerFactory.getLogger(ClientCallback.class);
    private final MqttBrokerConnection connection;
    private final List<MqttConnectionObserver> connectionObservers;
    private final Map<String, TopicSubscribers> subscribers;

    public ClientCallback(MqttBrokerConnection mqttBrokerConnectionImpl, List<MqttConnectionObserver> connectionObservers, Map<String, TopicSubscribers> subscribers) {
        this.connection = mqttBrokerConnectionImpl;
        this.connectionObservers = connectionObservers;
        this.subscribers = subscribers;
    }

    public synchronized void connectionLost(@Nullable Throwable exception) {
        if (exception instanceof MqttException) {
            MqttException e = (MqttException)exception;
            this.logger.info("MQTT connection to '{}' was lost: {} : ReasonCode {} : Cause : {}", new Object[]{this.connection.getHost(), e.getMessage(), e.getReasonCode(), e.getCause() == null ? "Unknown" : e.getCause().getMessage()});
        } else if (exception != null) {
            this.logger.info("MQTT connection to '{}' was lost", (Object)this.connection.getHost(), (Object)exception);
        }
        this.connectionObservers.forEach(o -> o.connectionStateChanged(MqttConnectionState.DISCONNECTED, exception));
        AbstractReconnectStrategy reconnectStrategy = this.connection.getReconnectStrategy();
        if (reconnectStrategy != null) {
            reconnectStrategy.lostConnection();
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        this.logger.trace("Message with id {} delivered.", (Object)token.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(String topic, MqttMessage message) {
        byte[] payload = message.getPayload();
        this.logger.trace("Received message on topic '{}' : {}", (Object)topic, (Object)new String(payload));
        ArrayList matches = new ArrayList();
        Map<String, TopicSubscribers> map = this.subscribers;
        synchronized (map) {
            this.subscribers.values().forEach(subscriberList -> {
                if (topic.matches(subscriberList.regexMatchTopic)) {
                    this.logger.trace("Topic match for '{}' using regex {}", (Object)topic, (Object)subscriberList.regexMatchTopic);
                    subscriberList.forEach(consumer -> {
                        boolean bl = matches.add(consumer);
                    });
                } else {
                    this.logger.trace("No topic match for '{}' using regex {}", (Object)topic, (Object)subscriberList.regexMatchTopic);
                }
            });
        }
        try {
            matches.forEach(subscriber -> subscriber.processMessage(topic, payload));
        }
        catch (Exception e) {
            this.logger.error("MQTT message received. MqttMessageSubscriber#processMessage() implementation failure", (Throwable)e);
        }
    }
}

