/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.serial.internal;

import gnu.io.CommPortIdentifier;
import gnu.io.RXTXPort;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.io.transport.serial.PortInUseException;
import org.eclipse.smarthome.io.transport.serial.SerialPort;
import org.eclipse.smarthome.io.transport.serial.SerialPortIdentifier;
import org.eclipse.smarthome.io.transport.serial.rxtx.RxTxSerialPort;

@NonNullByDefault
public class SerialPortIdentifierImpl
implements SerialPortIdentifier {
    final CommPortIdentifier id;

    public SerialPortIdentifierImpl(CommPortIdentifier id) {
        this.id = id;
    }

    public String getName() {
        String name = this.id.getName();
        return name != null ? name : "";
    }

    public SerialPort open(String owner, int timeout) throws PortInUseException {
        try {
            RXTXPort cp = this.id.open(owner, timeout);
            if (cp instanceof gnu.io.SerialPort) {
                return new RxTxSerialPort((gnu.io.SerialPort)cp);
            }
            throw new IllegalStateException(String.format("We expect an serial port instead of '%s'", cp.getClass()));
        }
        catch (gnu.io.PortInUseException portInUseException) {
            throw new PortInUseException();
        }
    }

    public boolean isCurrentlyOwned() {
        return this.id.isCurrentlyOwned();
    }

    public @Nullable String getCurrentOwner() {
        return this.id.getCurrentOwner();
    }
}

