/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.javascript.internal;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.service.AbstractWatchService;
import org.eclipse.smarthome.transform.javascript.internal.JavaScriptEngineManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class TransformationScriptWatcher
extends AbstractWatchService {
    public static final String TRANSFORM_FOLDER = String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + "transform";
    private JavaScriptEngineManager manager;

    public TransformationScriptWatcher() {
        super(TRANSFORM_FOLDER);
    }

    @Reference
    public void setJavaScriptEngineManager(JavaScriptEngineManager manager) {
        this.manager = manager;
    }

    public void unsetJavaScriptEngineManager(JavaScriptEngineManager manager) {
        this.manager = null;
    }

    public void activate() {
        super.activate();
    }

    protected boolean watchSubDirectories() {
        return true;
    }

    protected WatchEvent.Kind<?>[] getWatchEventKinds(Path directory) {
        return new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    }

    protected void processWatchEvent(WatchEvent<?> event, WatchEvent.Kind<?> kind, Path path) {
        this.logger.debug("New watch event {} for path {}.", kind, (Object)path);
        if (kind == StandardWatchEventKinds.OVERFLOW) {
            return;
        }
        WatchEvent<?> ev = event;
        Path filename = (Path)ev.context();
        this.logger.debug("Reloading javascript file {}.", (Object)filename);
        this.manager.removeFromCache(filename.toString());
    }
}

