/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.jsonpath.internal;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.eclipse.smarthome.core.types.UnDefType;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, property={"smarthome.transform=JSONPATH"})
public class JSonPathTransformationService
implements TransformationService {
    private final Logger logger = LoggerFactory.getLogger(JSonPathTransformationService.class);

    public @Nullable String transform(String jsonPathExpression, String source) throws TransformationException {
        Object transformationResult;
        block6: {
            if (jsonPathExpression == null || source == null) {
                throw new TransformationException("the given parameters 'JSonPath' and 'source' must not be null");
            }
            this.logger.debug("about to transform '{}' by the function '{}'", (Object)source, (Object)jsonPathExpression);
            transformationResult = JsonPath.read((String)source, (String)jsonPathExpression, (Predicate[])new Predicate[0]);
            this.logger.debug("transformation resulted in '{}'", transformationResult);
            if (transformationResult != null) break block6;
            return null;
        }
        try {
            if (transformationResult instanceof List) {
                return this.flattenList((List)transformationResult);
            }
            return transformationResult.toString();
        }
        catch (PathNotFoundException pathNotFoundException) {
            throw new TransformationException("Invalid path '" + jsonPathExpression + "' in '" + source + "'");
        }
        catch (InvalidJsonException | InvalidPathException e) {
            throw new TransformationException("An error occurred while transforming JSON expression.", e);
        }
    }

    private String flattenList(List<?> list) {
        if (list.size() == 1) {
            return list.get(0).toString();
        }
        if (list.size() > 1) {
            this.logger.warn("JsonPath expressions with more than one result are not allowed, please adapt your selector. Result: {}", list);
        }
        return UnDefType.NULL.toFullString();
    }
}

