/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.dto;

import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.dto.ActionDTOMapper;
import org.eclipse.smarthome.automation.dto.ConditionDTOMapper;
import org.eclipse.smarthome.automation.dto.RuleDTO;
import org.eclipse.smarthome.automation.dto.TriggerDTOMapper;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTOMapper;

public class RuleDTOMapper {
    public static RuleDTO map(Rule rule) {
        RuleDTO ruleDto = new RuleDTO();
        RuleDTOMapper.fillProperties(rule, ruleDto);
        return ruleDto;
    }

    public static Rule map(RuleDTO ruleDto) {
        Rule rule = new Rule(ruleDto.uid, TriggerDTOMapper.mapDto(ruleDto.triggers), ConditionDTOMapper.mapDto(ruleDto.conditions), ActionDTOMapper.mapDto(ruleDto.actions), ConfigDescriptionDTOMapper.map(ruleDto.configDescriptions), new Configuration(ruleDto.configuration), ruleDto.templateUID, ruleDto.visibility);
        rule.setTags(ruleDto.tags);
        rule.setName(ruleDto.name);
        rule.setDescription(ruleDto.description);
        return rule;
    }

    protected static void fillProperties(Rule from, RuleDTO to) {
        to.triggers = TriggerDTOMapper.map(from.getTriggers());
        to.conditions = ConditionDTOMapper.map(from.getConditions());
        to.actions = ActionDTOMapper.map(from.getActions());
        to.configuration = from.getConfiguration().getProperties();
        to.configDescriptions = ConfigDescriptionDTOMapper.mapParameters(from.getConfigurationDescriptions());
        to.templateUID = from.getTemplateUID();
        to.uid = from.getUID();
        to.name = from.getName();
        to.tags = from.getTags();
        to.visibility = from.getVisibility();
        to.description = from.getDescription();
    }
}

