/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.osgi.framework.BundleContext;

public abstract class BaseModuleHandlerFactory
implements ModuleHandlerFactory {
    private Map<String, ModuleHandler> handlers = new HashMap<String, ModuleHandler>();
    protected BundleContext bundleContext;

    public void activate(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("BundleContext must not be null.");
        }
        this.bundleContext = bundleContext;
    }

    public void deactivate() {
        this.dispose();
    }

    protected Map<String, ModuleHandler> getHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    @Override
    public ModuleHandler getHandler(Module module, String ruleUID) {
        ModuleHandler handler = this.handlers.get(String.valueOf(ruleUID) + module.getId());
        if (handler == null && (handler = this.internalCreate(module, ruleUID)) != null) {
            this.handlers.put(String.valueOf(ruleUID) + module.getId(), handler);
        }
        return handler;
    }

    protected abstract ModuleHandler internalCreate(Module var1, String var2);

    public void dispose() {
        for (ModuleHandler handler : this.handlers.values()) {
            if (handler == null) continue;
            handler.dispose();
        }
        this.handlers.clear();
    }

    @Override
    public void ungetHandler(Module module, String ruleUID, ModuleHandler hdlr) {
        ModuleHandler handler = this.handlers.get(String.valueOf(ruleUID) + module.getId());
        if (handler != null) {
            this.handlers.remove(String.valueOf(ruleUID) + module.getId());
            if (!this.handlers.containsValue(hdlr)) {
                handler.dispose();
                handler = null;
            }
        }
    }
}

