/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleProvider;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.RuleStatusInfo;
import org.eclipse.smarthome.automation.StatusInfoCallback;
import org.eclipse.smarthome.automation.core.internal.RuleEngine;
import org.eclipse.smarthome.automation.core.internal.RuleUtils;
import org.eclipse.smarthome.automation.core.internal.composite.CompositeModuleHandlerFactory;
import org.eclipse.smarthome.automation.core.internal.template.RuleTemplateRegistry;
import org.eclipse.smarthome.automation.events.RuleEventFactory;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.TemplateRegistry;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleRegistryImpl
extends AbstractRegistry<Rule, String, RuleProvider>
implements RuleRegistry,
StatusInfoCallback,
RegistryChangeListener<RuleTemplate> {
    private static final String DISABLED_RULE_STORAGE = "automation_rules_disabled";
    private static final String SOURCE = RuleRegistryImpl.class.getSimpleName();
    private static final Logger logger = LoggerFactory.getLogger((String)RuleRegistryImpl.class.getName());
    private final RuleEngine ruleEngine = new RuleEngine();
    private Storage<Boolean> disabledRulesStorage;
    private ModuleTypeRegistry moduleTypeRegistry;
    private RuleTemplateRegistry templateRegistry;
    private final Map<String, Set<String>> mapTemplateToRules = new HashMap<String, Set<String>>();

    public RuleRegistryImpl() {
        super(RuleProvider.class);
    }

    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws Exception {
        this.ruleEngine.setCompositeModuleHandlerFactory(new CompositeModuleHandlerFactory(bundleContext, this.moduleTypeRegistry, this.ruleEngine));
        this.ruleEngine.setStatusInfoCallback(this);
        this.modified(properties);
        super.activate(bundleContext);
    }

    protected void modified(Map<String, Object> config) {
        this.ruleEngine.scheduleRulesConfigurationUpdated(config);
    }

    protected void deactivate() {
        super.deactivate();
        this.ruleEngine.dispose();
    }

    protected void setModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.moduleTypeRegistry = moduleTypeRegistry;
        this.ruleEngine.setModuleTypeRegistry(moduleTypeRegistry);
    }

    protected void unsetModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.moduleTypeRegistry = null;
        this.ruleEngine.setModuleTypeRegistry(null);
    }

    protected void setTemplateRegistry(TemplateRegistry<RuleTemplate> templateRegistry) {
        if (templateRegistry instanceof RuleTemplateRegistry) {
            this.templateRegistry = (RuleTemplateRegistry)templateRegistry;
            templateRegistry.addRegistryChangeListener((RegistryChangeListener)this);
        }
    }

    protected void unsetTemplateRegistry(TemplateRegistry<RuleTemplate> templateRegistry) {
        if (templateRegistry instanceof RuleTemplateRegistry) {
            this.templateRegistry = null;
            templateRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        }
    }

    protected void setStorageService(StorageService storageService) {
        this.disabledRulesStorage = storageService.getStorage(DISABLED_RULE_STORAGE, ((Object)((Object)this)).getClass().getClassLoader());
        for (Rule rule : this.getAll()) {
            String uid = rule.getUID();
            if (this.disabledRulesStorage.get(uid) != null) continue;
            this.setEnabled(uid, Boolean.TRUE);
        }
    }

    protected void unsetStorageService(StorageService storageService) {
        this.disabledRulesStorage = null;
        for (Rule rule : this.getAll()) {
            this.ruleEngine.setRuleEnabled(rule, Boolean.FALSE);
        }
    }

    protected void addModuleHandlerFactory(ModuleHandlerFactory moduleHandlerFactory) {
        this.ruleEngine.addModuleHandlerFactory(moduleHandlerFactory);
    }

    protected void removeModuleHandlerFactory(ModuleHandlerFactory moduleHandlerFactory) {
        this.ruleEngine.removeModuleHandlerFactory(moduleHandlerFactory);
    }

    public Rule add(Rule rule) {
        super.add((Identifiable)rule);
        Rule ruleCopy = this.get(rule.getUID());
        if (ruleCopy != null) {
            return ruleCopy;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersAboutAddedElement(Rule rule) {
        block6: {
            super.notifyListenersAboutAddedElement((Identifiable)rule);
            this.postRuleAddedEvent(rule);
            String uid = rule.getUID();
            this.ruleEngine.addRule(rule, this.disabledRulesStorage != null && this.disabledRulesStorage.get(uid) == null);
            String templateUID = rule.getTemplateUID();
            if (templateUID == null) break block6;
            RuleRegistryImpl ruleRegistryImpl = this;
            synchronized (ruleRegistryImpl) {
                Set<String> ruleUIDs = this.mapTemplateToRules.get(templateUID);
                if (ruleUIDs == null) {
                    ruleUIDs = new HashSet<String>(11);
                    this.mapTemplateToRules.put(templateUID, ruleUIDs);
                }
                ruleUIDs.add(uid);
            }
        }
    }

    protected void postRuleAddedEvent(Rule rule) {
        this.postEvent((Event)RuleEventFactory.createRuleAddedEvent((Rule)rule, (String)SOURCE));
    }

    protected void postRuleRemovedEvent(Rule rule) {
        this.postEvent((Event)RuleEventFactory.createRuleRemovedEvent((Rule)rule, (String)SOURCE));
    }

    protected void postRuleUpdatedEvent(Rule rule, Rule oldRule) {
        this.postEvent((Event)RuleEventFactory.createRuleUpdatedEvent((Rule)rule, (Rule)oldRule, (String)SOURCE));
    }

    protected void postRuleStatusInfoEvent(RuleStatusInfo statusInfo, String ruleUID) {
        this.postEvent((Event)RuleEventFactory.createRuleStatusInfoEvent((RuleStatusInfo)statusInfo, (String)ruleUID, (String)SOURCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRemoveElement(Rule rule) {
        String uid = rule.getUID();
        this.ruleEngine.removeRule(uid);
        String templateUID = rule.getTemplateUID();
        if (templateUID != null) {
            RuleRegistryImpl ruleRegistryImpl = this;
            synchronized (ruleRegistryImpl) {
                Set<String> ruleUIDs = this.mapTemplateToRules.get(templateUID);
                if (ruleUIDs != null) {
                    ruleUIDs.remove(uid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersAboutUpdatedElement(Rule oldElement, Rule element) {
        super.notifyListenersAboutUpdatedElement((Identifiable)oldElement, (Identifiable)element);
        this.postRuleUpdatedEvent(element, oldElement);
        String uid = element.getUID();
        this.ruleEngine.updateRule(element, this.disabledRulesStorage != null && this.disabledRulesStorage.get(uid) == null);
        String templateUID = element.getTemplateUID();
        if (templateUID != null) {
            RuleRegistryImpl ruleRegistryImpl = this;
            synchronized (ruleRegistryImpl) {
                Set<String> ruleUIDs = this.mapTemplateToRules.get(templateUID);
                if (ruleUIDs != null) {
                    ruleUIDs.remove(uid);
                }
            }
        }
    }

    protected void notifyListenersAboutRemovedElement(Rule element) {
        super.notifyListenersAboutRemovedElement((Identifiable)element);
        this.postRuleRemovedEvent(element);
    }

    public Rule get(String key) {
        for (Collection rules : this.elementMap.values()) {
            for (Rule rule : rules) {
                if (!rule.getUID().equals(key)) continue;
                return RuleUtils.getRuleCopy(rule);
            }
        }
        return null;
    }

    public Stream<Rule> stream() {
        return super.stream().map(r -> RuleUtils.getRuleCopy(r));
    }

    public Collection<Rule> getByTag(String tag) {
        LinkedList<Rule> result = new LinkedList<Rule>();
        if (tag != null) {
            for (Collection rules : this.elementMap.values()) {
                for (Rule rule : rules) {
                    if (!rule.getTags().contains(tag)) continue;
                    result.add(RuleUtils.getRuleCopy(rule));
                }
            }
        } else {
            for (Collection rules : this.elementMap.values()) {
                for (Rule rule : rules) {
                    result.add(RuleUtils.getRuleCopy(rule));
                }
            }
        }
        return result;
    }

    public Collection<Rule> getByTags(String ... tags) {
        HashSet<String> tagSet = tags != null ? new HashSet<String>(Arrays.asList(tags)) : null;
        LinkedList<Rule> result = new LinkedList<Rule>();
        if (tagSet == null || tagSet.isEmpty()) {
            for (Collection rules : this.elementMap.values()) {
                for (Rule rule : rules) {
                    result.add(RuleUtils.getRuleCopy(rule));
                }
            }
        } else {
            for (Collection rules : this.elementMap.values()) {
                for (Rule rule : rules) {
                    if (!rule.getTags().containsAll(tagSet)) continue;
                    result.add(RuleUtils.getRuleCopy(rule));
                }
            }
        }
        return result;
    }

    public synchronized void setEnabled(String uid, boolean isEnabled) {
        if (this.disabledRulesStorage == null) {
            throw new IllegalStateException("Persisting rule state failed. Storage service is not available!");
        }
        Rule rule = this.get(uid);
        if (rule == null) {
            throw new IllegalArgumentException(String.format("No rule with such id=%s was found!", uid));
        }
        this.ruleEngine.setRuleEnabled(rule, isEnabled);
        if (isEnabled) {
            this.disabledRulesStorage.remove(uid);
        } else {
            this.disabledRulesStorage.put(uid, (Object)isEnabled);
        }
    }

    public RuleStatusInfo getStatusInfo(String ruleUID) {
        return this.ruleEngine.getRuleStatusInfo(ruleUID);
    }

    public RuleStatus getStatus(String ruleUID) {
        return this.ruleEngine.getRuleStatus(ruleUID);
    }

    public void statusInfoChanged(String ruleUID, RuleStatusInfo statusInfo) {
        this.postRuleStatusInfoEvent(statusInfo, ruleUID);
    }

    public Boolean isEnabled(String ruleUID) {
        if (this.disabledRulesStorage != null && this.disabledRulesStorage.get(ruleUID) != null) {
            return Boolean.FALSE;
        }
        return this.ruleEngine.getRuleStatus(ruleUID) == null ? null : Boolean.valueOf(!this.ruleEngine.getRuleStatus(ruleUID).equals((Object)RuleStatus.DISABLED));
    }

    private Rule resolveRuleByTemplate(Rule rule) {
        String templateUID = rule.getTemplateUID();
        if (templateUID != null) {
            RuleTemplate template = this.templateRegistry.get(templateUID);
            if (template == null) {
                logger.debug("Rule template {} does not exist.", (Object)templateUID);
                return rule;
            }
            Rule resolvedRule = new Rule(rule.getUID(), RuleUtils.getTriggersCopy(template.getTriggers()), RuleUtils.getConditionsCopy(template.getConditions()), RuleUtils.getActionsCopy(template.getActions()), template.getConfigurationDescriptions(), rule.getConfiguration(), null, rule.getVisibility());
            String name = rule.getName();
            if (name != null) {
                resolvedRule.setName(name);
            }
            resolvedRule.setTags(rule.getTags());
            String description = rule.getDescription();
            if (description != null) {
                resolvedRule.setDescription(description);
            }
            this.ruleEngine.resolveConfiguration(resolvedRule);
            return resolvedRule;
        }
        return rule;
    }

    protected void addProvider(Provider<Rule> provider) {
        super.addProvider(provider);
        LinkedList rules = new LinkedList((Collection)this.elementMap.get(provider));
        for (Rule rule : rules) {
            this.updateRuleByTemplate(provider, rule);
        }
    }

    public void added(Provider<Rule> provider, Rule element) {
        super.added(provider, (Identifiable)element);
        this.updateRuleByTemplate(provider, element);
    }

    private void updateRuleByTemplate(Provider<Rule> provider, Rule rule) {
        Rule resolvedRule = this.resolveRuleByTemplate(rule);
        if (rule != resolvedRule && this.update((Identifiable)resolvedRule) == null) {
            super.updated(provider, (Identifiable)rule, (Identifiable)resolvedRule);
        }
    }

    public void updated(Provider<Rule> provider, Rule oldElement, Rule element) {
        Rule resolvedRule = this.resolveRuleByTemplate(element);
        super.updated(provider, (Identifiable)oldElement, (Identifiable)resolvedRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(RuleTemplate element) {
        String templateUID = element.getUID();
        HashSet<String> rules = new HashSet<String>();
        RuleRegistryImpl ruleRegistryImpl = this;
        synchronized (ruleRegistryImpl) {
            Set<String> rulesForResolving = this.mapTemplateToRules.remove(templateUID);
            if (rulesForResolving != null) {
                rules.addAll(rulesForResolving);
            }
        }
        for (String rUID : rules) {
            Rule rule = this.get(rUID);
            this.updateRuleByTemplate(this.getProvider(rule), rule);
        }
    }

    private Provider<Rule> getProvider(Rule rule) {
        for (Map.Entry entry : this.elementMap.entrySet()) {
            if (!((Collection)entry.getValue()).contains(rule)) continue;
            return (Provider)entry.getKey();
        }
        return null;
    }

    public void removed(RuleTemplate element) {
    }

    public void updated(RuleTemplate oldElement, RuleTemplate element) {
    }

    public void runNow(String ruleUID) {
        this.ruleEngine.runNow(ruleUID);
    }

    public void runNow(String ruleUID, boolean considerConditions, Map<String, Object> context) {
        this.ruleEngine.runNow(ruleUID, considerConditions, context);
    }
}

