/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.composite;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.core.internal.ReferenceResolverUtil;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.type.ModuleType;

public abstract class AbstractCompositeModuleHandler<M extends Module, MT extends ModuleType, H extends ModuleHandler>
implements ModuleHandler {
    protected LinkedHashMap<M, H> moduleHandlerMap;
    protected M module;
    protected MT moduleType;

    public AbstractCompositeModuleHandler(M module, MT moduleType, LinkedHashMap<M, H> mapModuleToHandler) {
        this.module = module;
        this.moduleType = moduleType;
        this.moduleHandlerMap = mapModuleToHandler;
    }

    protected Map<String, Object> getCompositeContext(Map<String, ?> context) {
        HashMap<String, Object> result = new HashMap<String, Object>(context);
        result.putAll(this.module.getConfiguration().getProperties());
        return result;
    }

    protected Map<String, Object> getChildContext(Module child, Map<String, ?> compositeContext) {
        return ReferenceResolverUtil.getCompositeChildContext(child, compositeContext);
    }

    public void dispose() {
        List<M> children = this.getChildren();
        for (Module child : children) {
            ModuleHandler childHandler = (ModuleHandler)this.moduleHandlerMap.remove(child);
            if (childHandler == null) continue;
            childHandler.dispose();
        }
        this.moduleHandlerMap = null;
    }

    protected abstract List<M> getChildren();
}

