/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.composite;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.ReferenceResolverUtil;
import org.eclipse.smarthome.automation.core.internal.RuleEngine;
import org.eclipse.smarthome.automation.core.internal.composite.AbstractCompositeModuleHandler;
import org.eclipse.smarthome.automation.core.internal.composite.CompositeActionHandler;
import org.eclipse.smarthome.automation.core.internal.composite.CompositeConditionHandler;
import org.eclipse.smarthome.automation.core.internal.composite.CompositeTriggerHandler;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.handler.BaseModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.TriggerHandler;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.config.core.Configuration;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeModuleHandlerFactory
extends BaseModuleHandlerFactory
implements ModuleHandlerFactory {
    private ModuleTypeRegistry mtRegistry;
    private RuleEngine ruleEngine;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public CompositeModuleHandlerFactory(BundleContext bc, ModuleTypeRegistry mtRegistry, RuleEngine re) {
        this.mtRegistry = mtRegistry;
        this.ruleEngine = re;
        this.activate(bc);
    }

    public Collection<String> getTypes() {
        return null;
    }

    public void ungetHandler(Module module, String childModulePrefix, ModuleHandler handler) {
        ModuleHandler handlerOfModule = (ModuleHandler)this.getHandlers().get(String.valueOf(childModulePrefix) + module.getId());
        if (handlerOfModule instanceof AbstractCompositeModuleHandler) {
            AbstractCompositeModuleHandler h = (AbstractCompositeModuleHandler)handlerOfModule;
            Set modules = h.moduleHandlerMap.keySet();
            if (modules != null) {
                for (Module child : modules) {
                    ModuleHandler childHandler = (ModuleHandler)h.moduleHandlerMap.get(child);
                    ModuleHandlerFactory mhf = this.ruleEngine.getModuleHandlerFactory(child.getTypeUID());
                    mhf.ungetHandler(child, String.valueOf(childModulePrefix) + ":" + module.getId(), childHandler);
                }
            }
        }
        String ruleId = this.getRuleId(childModulePrefix);
        super.ungetHandler(module, ruleId, handler);
    }

    private String getRuleId(String childModulePrefix) {
        int i = childModulePrefix.indexOf(58);
        String ruleId = i != -1 ? childModulePrefix.substring(0, i) : childModulePrefix;
        return ruleId;
    }

    public ModuleHandler internalCreate(Module module, String ruleUID) {
        Object handler = null;
        if (module != null) {
            String moduleType = module.getTypeUID();
            ModuleType mt = (ModuleType)this.mtRegistry.get((Object)moduleType);
            if (mt instanceof CompositeTriggerType) {
                List childModules = ((CompositeTriggerType)mt).getChildren();
                LinkedHashMap<Trigger, TriggerHandler> mapModuleToHandler = this.getChildHandlers(module.getId(), module.getConfiguration(), childModules, ruleUID);
                if (mapModuleToHandler != null) {
                    handler = new CompositeTriggerHandler((Trigger)module, (CompositeTriggerType)mt, mapModuleToHandler, ruleUID);
                }
            } else if (mt instanceof CompositeConditionType) {
                List childModules = ((CompositeConditionType)mt).getChildren();
                LinkedHashMap<Condition, ConditionHandler> mapModuleToHandler = this.getChildHandlers(module.getId(), module.getConfiguration(), childModules, ruleUID);
                if (mapModuleToHandler != null) {
                    handler = new CompositeConditionHandler((Condition)module, (CompositeConditionType)mt, mapModuleToHandler, ruleUID);
                }
            } else if (mt instanceof CompositeActionType) {
                List childModules = ((CompositeActionType)mt).getChildren();
                LinkedHashMap<Action, ActionHandler> mapModuleToHandler = this.getChildHandlers(module.getId(), module.getConfiguration(), childModules, ruleUID);
                if (mapModuleToHandler != null) {
                    handler = new CompositeActionHandler((Action)module, (CompositeActionType)mt, mapModuleToHandler, ruleUID);
                }
            }
            if (handler != null) {
                this.logger.debug("Set module handler: {}  -> {} of rule {}.", new Object[]{module.getId(), String.valueOf(handler.getClass().getSimpleName()) + "(" + moduleType + ")", ruleUID});
            } else {
                this.logger.debug("Not found module handler {} for moduleType {} of rule {}.", new Object[]{module.getId(), moduleType, ruleUID});
            }
        }
        return handler;
    }

    private <T extends Module, MT extends ModuleHandler> LinkedHashMap<T, MT> getChildHandlers(String compositeModuleId, Configuration compositeConfig, List<T> childModules, String childModulePrefix) {
        LinkedHashMap<Module, ModuleHandler> mapModuleToHandler = new LinkedHashMap<Module, ModuleHandler>();
        for (Module child : childModules) {
            String ruleId = this.getRuleId(childModulePrefix);
            this.ruleEngine.updateMapModuleTypeToRule(ruleId, child.getTypeUID());
            ModuleHandlerFactory childMhf = this.ruleEngine.getModuleHandlerFactory(child.getTypeUID());
            if (childMhf == null) {
                mapModuleToHandler.clear();
                mapModuleToHandler = null;
                return null;
            }
            ReferenceResolverUtil.updateModuleConfiguration(child, compositeConfig.getProperties());
            ModuleHandler childHandler = childMhf.getHandler(child, String.valueOf(childModulePrefix) + ":" + compositeModuleId);
            if (childHandler == null) {
                mapModuleToHandler.clear();
                mapModuleToHandler = null;
                return null;
            }
            mapModuleToHandler.put(child, childHandler);
        }
        return mapModuleToHandler;
    }

    public void dispose() {
        super.dispose();
        this.mtRegistry = null;
        this.ruleEngine = null;
    }
}

